/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.setup;

import io.github.wouink.furnish.Furnish;
import io.github.wouink.furnish.block.Crate;
import io.github.wouink.furnish.block.Mailbox;
import io.github.wouink.furnish.block.container.CrateContainer;
import io.github.wouink.furnish.block.container.DiskRackContainer;
import io.github.wouink.furnish.block.container.FurnitureWorkbenchContainer;
import io.github.wouink.furnish.block.container.MailboxContainer;
import io.github.wouink.furnish.block.tileentity.AmphoraTileEntity;
import io.github.wouink.furnish.block.tileentity.CrateTileEntity;
import io.github.wouink.furnish.block.tileentity.DiskRackTileEntity;
import io.github.wouink.furnish.block.tileentity.FurnitureTileEntity;
import io.github.wouink.furnish.block.tileentity.LargeFurnitureTileEntity;
import io.github.wouink.furnish.block.tileentity.MailboxTileEntity;
import io.github.wouink.furnish.block.tileentity.PlateTileEntity;
import io.github.wouink.furnish.block.tileentity.ShelfTileEntity;
import io.github.wouink.furnish.block.tileentity.ShowcaseTileEntity;
import io.github.wouink.furnish.client.gui.ConditionalSlotContainerScreen;
import io.github.wouink.furnish.client.gui.DiskRackScreen;
import io.github.wouink.furnish.client.gui.FurnitureWorkbenchScreen;
import io.github.wouink.furnish.client.renderer.DiskRackRenderer;
import io.github.wouink.furnish.client.renderer.MailboxRenderer;
import io.github.wouink.furnish.client.renderer.PlateRenderer;
import io.github.wouink.furnish.client.renderer.SeatRenderer;
import io.github.wouink.furnish.client.renderer.ShelfRenderer;
import io.github.wouink.furnish.client.renderer.ShowcaseRenderer;
import io.github.wouink.furnish.entity.SeatEntity;
import io.github.wouink.furnish.recipe.FSingleItemRecipe;
import io.github.wouink.furnish.recipe.FurnitureRecipe;
import io.github.wouink.furnish.setup.FurnishBlocks;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FurnishData {
    public static final ResourceLocation Furniture_Recipe_Loc = new ResourceLocation("furnish", "furniture_making");
    public static final RecipeType<FurnitureRecipe> Furniture_Recipe = RecipeType.m_44119_((String)Furniture_Recipe_Loc.toString());

    public static void setup(IEventBus bus) {
        Containers.Registry.register(bus);
        Furnish.LOG.info("Registered Furnish Containers.");
        RecipeSerializers.Registry.register(bus);
        Furnish.LOG.info("Registered Furnish Recipes Serializers.");
        Entities.Registry.register(bus);
        Furnish.LOG.info("Registered Furnish Entities.");
        TileEntities.Registry.register(bus);
        Furnish.LOG.info("Registered Furnish Tile Entities.");
        Sounds.Registry.register(bus);
        Furnish.LOG.info("Registered Furnish Sounds.");
    }

    public static void clientSetup() {
        MenuScreens.m_96206_((MenuType)((MenuType)Containers.Furniture_Workbench.get()), FurnitureWorkbenchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Containers.Crate.get()), ConditionalSlotContainerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Containers.Mailbox.get()), ConditionalSlotContainerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Containers.Disk_Rack.get()), DiskRackScreen::new);
        Furnish.LOG.info("Registered Furnish Screens.");
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)Entities.Seat_Entity.get(), SeatRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TileEntities.TE_Mailbox.get(), MailboxRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TileEntities.TE_Plate.get(), PlateRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TileEntities.TE_Shelf.get(), ShelfRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TileEntities.TE_Showcase.get(), ShowcaseRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TileEntities.TE_Disk_Rack.get(), DiskRackRenderer::new);
        Furnish.LOG.info("Registered Furnish Entity/BlockEntity Renderers.");
    }

    public static Motive createPainting(String name, int w, int h) {
        Motive painting = new Motive(16 * w, 16 * h);
        painting.setRegistryName("furnish", name);
        return painting;
    }

    @SubscribeEvent
    public static void registerPaintings(RegistryEvent.Register<Motive> paintingRegistryEvent) {
        IForgeRegistry paintingRegistry = paintingRegistryEvent.getRegistry();
        paintingRegistry.register((IForgeRegistryEntry)FurnishData.createPainting("steve", 1, 1));
        paintingRegistry.register((IForgeRegistryEntry)FurnishData.createPainting("alex", 1, 1));
        Furnish.LOG.info("Registered Furnish Paintings.");
    }

    public static class Containers {
        public static final DeferredRegister<MenuType<?>> Registry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"furnish");
        public static final RegistryObject<MenuType<FurnitureWorkbenchContainer>> Furniture_Workbench = Registry.register("furniture_workbench", () -> new MenuType(FurnitureWorkbenchContainer::new));
        public static final RegistryObject<MenuType<CrateContainer>> Crate = Registry.register("crate", () -> new MenuType(CrateContainer::new));
        public static final RegistryObject<MenuType<MailboxContainer>> Mailbox = Registry.register("mailbox", () -> new MenuType(MailboxContainer::new));
        public static final RegistryObject<MenuType<DiskRackContainer>> Disk_Rack = Registry.register("disk_rack", () -> new MenuType(DiskRackContainer::new));
    }

    public static class RecipeSerializers {
        public static final DeferredRegister<RecipeSerializer<?>> Registry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"furnish");
        public static final RegistryObject<RecipeSerializer<FurnitureRecipe>> Furniture_Recipe_Serializer = Registry.register("furniture_making", () -> new FSingleItemRecipe.Serializer<FurnitureRecipe>(FurnitureRecipe::new){});
    }

    public static class Entities {
        public static final DeferredRegister<EntityType<?>> Registry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"furnish");
        public static final RegistryObject<EntityType<SeatEntity>> Seat_Entity = Entities.register("seat", EntityType.Builder.m_20704_((type, world) -> new SeatEntity(world), (MobCategory)MobCategory.MISC).m_20699_(0.0f, 0.0f).setCustomClientFactory((spawnEntity, world) -> new SeatEntity((Level)world)));

        private static <T extends Entity> RegistryObject<EntityType<T>> register(String name, EntityType.Builder<T> builder) {
            return Registry.register(name, () -> builder.m_20712_(name));
        }
    }

    public static class TileEntities {
        public static final DeferredRegister<BlockEntityType<?>> Registry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"furnish");
        public static final RegistryObject<BlockEntityType<FurnitureTileEntity>> TE_Furniture = Registry.register("furniture", () -> BlockEntityType.Builder.m_155273_(FurnitureTileEntity::new, (Block[])FurnishBlocks.FurnitureInvProvider).m_58966_(null));
        public static final RegistryObject<BlockEntityType<LargeFurnitureTileEntity>> TE_Large_Furniture = Registry.register("large_furniture", () -> BlockEntityType.Builder.m_155273_(LargeFurnitureTileEntity::new, (Block[])FurnishBlocks.FurnitureLargeInvProvider).m_58966_(null));
        public static final RegistryObject<BlockEntityType<AmphoraTileEntity>> TE_Amphora = Registry.register("amphora", () -> BlockEntityType.Builder.m_155273_(AmphoraTileEntity::new, (Block[])FurnishBlocks.Amphorae).m_58966_(null));
        public static final RegistryObject<BlockEntityType<MailboxTileEntity>> TE_Mailbox = Registry.register("mailbox", () -> BlockEntityType.Builder.m_155273_(MailboxTileEntity::new, (Block[])((Block[])Mailbox.All_Mailboxes.toArray(new Mailbox[0]))).m_58966_(null));
        public static final RegistryObject<BlockEntityType<CrateTileEntity>> TE_Crate = Registry.register("crate", () -> BlockEntityType.Builder.m_155273_(CrateTileEntity::new, (Block[])Crate.All_Crates.toArray(new Crate[0])).m_58966_(null));
        public static final RegistryObject<BlockEntityType<PlateTileEntity>> TE_Plate = Registry.register("plate", () -> BlockEntityType.Builder.m_155273_(PlateTileEntity::new, (Block[])FurnishBlocks.Plates).m_58966_(null));
        public static final RegistryObject<BlockEntityType<ShelfTileEntity>> TE_Shelf = Registry.register("shelf", () -> BlockEntityType.Builder.m_155273_(ShelfTileEntity::new, (Block[])FurnishBlocks.Shelves).m_58966_(null));
        public static final RegistryObject<BlockEntityType<ShowcaseTileEntity>> TE_Showcase = Registry.register("showcase", () -> BlockEntityType.Builder.m_155273_(ShowcaseTileEntity::new, (Block[])FurnishBlocks.Showcases).m_58966_(null));
        public static final RegistryObject<BlockEntityType<DiskRackTileEntity>> TE_Disk_Rack = Registry.register("disk_rack", () -> BlockEntityType.Builder.m_155273_(DiskRackTileEntity::new, (Block[])FurnishBlocks.Disk_Racks).m_58966_(null));
    }

    public static class Sounds {
        public static final DeferredRegister<SoundEvent> Registry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"furnish");
        public static final RegistryObject<SoundEvent> Cabinet_Open = Sounds.registerSound("block.furniture.open");
        public static final RegistryObject<SoundEvent> Cabinet_Close = Sounds.registerSound("block.furniture.close");
        public static final RegistryObject<SoundEvent> Spruce_Cabinet_Open = Sounds.registerSound("block.furniture_spruce.open");
        public static final RegistryObject<SoundEvent> Spruce_Cabinet_Close = Sounds.registerSound("block.furniture_spruce.close");
        public static final RegistryObject<SoundEvent> Drawers_Open = Sounds.registerSound("block.furniture_drawers.open");
        public static final RegistryObject<SoundEvent> Drawers_Close = Sounds.registerSound("block.furniture_drawers.close");
        public static final RegistryObject<SoundEvent> Amphora_Open = Sounds.registerSound("block.amphora.open");
        public static final RegistryObject<SoundEvent> Amphora_Close = Sounds.registerSound("block.amphora.close");
        public static final RegistryObject<SoundEvent> Wooden_Door_Knock = Sounds.registerSound("event.knock_on_door.wood");
        public static final RegistryObject<SoundEvent> Iron_Door_Knock = Sounds.registerSound("event.knock_on_door.iron");
        public static final RegistryObject<SoundEvent> Mailbox_Update = Sounds.registerSound("block.mailbox.update");
        public static final RegistryObject<SoundEvent> Attach_To_Letter = Sounds.registerSound("item.letter.add_attachment");
        public static final RegistryObject<SoundEvent> Detach_From_Letter = Sounds.registerSound("item.letter.remove_attachment");
        public static final RegistryObject<SoundEvent> Curtain = Sounds.registerSound("block.curtain.interact");

        private static RegistryObject<SoundEvent> registerSound(String key) {
            return Registry.register(key, () -> new SoundEvent(new ResourceLocation("furnish", key)));
        }
    }
}

