/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.integration.jei;

import io.github.wouink.furnish.integration.jei.FurnishJEIPlugin;
import io.github.wouink.furnish.recipe.FurnitureRecipe;
import io.github.wouink.furnish.setup.FurnishBlocks;
import io.github.wouink.furnish.setup.FurnishData;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FurnitureRecipeCategory
implements IRecipeCategory<FurnitureRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final int Input_Slot = 0;
    private final int Output_Slot = 1;

    public FurnitureRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(FurnishJEIPlugin.JEI_UI, 0, 220, 82, 34);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)FurnishBlocks.Furniture_Workbench));
    }

    public ResourceLocation getUid() {
        return FurnishData.Furniture_Recipe_Loc;
    }

    public Class<? extends FurnitureRecipe> getRecipeClass() {
        return FurnitureRecipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("furnish.furniture_making");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(FurnitureRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void setRecipe(IRecipeLayout recipeLayout, FurnitureRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup stackGroup = recipeLayout.getItemStacks();
        stackGroup.init(0, true, 0, 8);
        stackGroup.init(1, false, 60, 8);
        stackGroup.set(ingredients);
    }
}

