/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block;

import io.github.wouink.furnish.Furnish;
import io.github.wouink.furnish.block.tileentity.MailboxTileEntity;
import io.github.wouink.furnish.block.util.VoxelShapeHelper;
import io.github.wouink.furnish.setup.FurnishData;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Mailbox
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static ArrayList<Mailbox> All_Mailboxes = new ArrayList();
    public static final VoxelShape[] MAILBOX_SHAPE = VoxelShapeHelper.getRotatedShapes(Block.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)12.0, (double)13.0));
    public static final BooleanProperty ON_FENCE = BooleanProperty.m_61465_((String)"on_fence");
    public static final BooleanProperty HAS_MAIL = BooleanProperty.m_61465_((String)"has_mail");

    public Mailbox(BlockBehaviour.Properties p) {
        super(p);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)ON_FENCE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_MAIL, (Comparable)Boolean.valueOf(false)));
        All_Mailboxes.add(this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, ON_FENCE, HAS_MAIL});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
        if (ctx.m_43725_().m_8055_(ctx.m_8083_().m_7495_()).m_60734_() instanceof FenceBlock) {
            state = (BlockState)state.m_61124_((Property)ON_FENCE, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity tileEntity;
        if (entity instanceof Player) {
            ((Player)entity).m_5661_((Component)new TranslatableComponent("msg.furnish.mailbox.ownership_info"), true);
        }
        if (stack.m_41788_() && (tileEntity = world.m_7702_(pos)) instanceof MailboxTileEntity) {
            ((MailboxTileEntity)tileEntity).m_58638_(stack.m_41786_());
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return MAILBOX_SHAPE[((Direction)state.m_61143_((Property)f_54117_)).ordinal() - 2];
    }

    private boolean updateMailbox(BlockState state, Level world, BlockPos pos) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof MailboxTileEntity) {
            boolean mail = ((MailboxTileEntity)tileEntity).hasMail();
            if ((Boolean)state.m_61143_((Property)HAS_MAIL) != mail) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_MAIL, (Comparable)Boolean.valueOf(mail)), 3);
                tileEntity.m_6596_();
                world.m_5594_(null, pos, (SoundEvent)FurnishData.Sounds.Mailbox_Update.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player playerEntity, InteractionHand hand, BlockHitResult hitResult) {
        if (world.m_5776_()) {
            return InteractionResult.m_19078_((boolean)true);
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        if (!(tileEntity instanceof MailboxTileEntity)) {
            return InteractionResult.FAIL;
        }
        MailboxTileEntity mailbox = (MailboxTileEntity)tileEntity;
        if (!mailbox.hasOwner()) {
            Furnish.LOG.debug("Mailbox does not have an owner -- setting owner and quitting");
            mailbox.setOwner(playerEntity);
            playerEntity.m_5661_((Component)new TranslatableComponent("msg.furnish.mailbox.set_owner"), true);
            return InteractionResult.m_19078_((boolean)false);
        }
        Furnish.LOG.debug("Mailbox has an owner -- continuing");
        if (mailbox.isOwner(playerEntity)) {
            Furnish.LOG.debug("Player is the owner -- updating state or opening UI, and quitting");
            mailbox.updateDisplayName(playerEntity);
            if (!this.updateMailbox(state, world, pos)) {
                playerEntity.m_5893_((MenuProvider)mailbox);
            }
            return InteractionResult.m_19078_((boolean)false);
        }
        Furnish.LOG.debug("Player is not the owner -- continuing");
        if (playerEntity.m_21120_(hand).m_41619_()) {
            Furnish.LOG.debug("Player has no item in hand -- quitting");
            playerEntity.m_5661_((Component)new TranslatableComponent("msg.furnish.mailbox.no_permission"), true);
            return InteractionResult.FAIL;
        }
        Furnish.LOG.debug("Player has an item in hand -- continuing");
        if (mailbox.isFull()) {
            Furnish.LOG.debug("Mailbox is full -- quitting");
            playerEntity.m_5661_((Component)new TranslatableComponent("msg.furnish.mailbox.full"), true);
            return InteractionResult.FAIL;
        }
        Furnish.LOG.debug("Mailbox is not full -- continuing");
        ItemStack result = mailbox.addMail(playerEntity.m_21120_(hand));
        playerEntity.m_21008_(hand, result);
        this.updateMailbox(state, world, pos);
        if (result.m_41619_()) {
            Furnish.LOG.debug("Mail is added to mailbox -- quitting");
            Component ownerName = mailbox.getOwnerDisplayName();
            if (ownerName != null) {
                playerEntity.m_5661_((Component)new TranslatableComponent("msg.furnish.mailbox.mail_delivered_to", new Object[]{ownerName}), true);
            } else {
                playerEntity.m_5661_((Component)new TranslatableComponent("msg.furnish.mailbox.mail_delivered"), true);
            }
            return InteractionResult.m_19078_((boolean)false);
        }
        Furnish.LOG.debug("Mail is not added to mailbox -- end of method");
        playerEntity.m_5661_((Component)new TranslatableComponent("msg.furnish.mailbox.invalid_mail"), true);
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MailboxTileEntity(pos, state);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moving) {
        BlockEntity tileEntity;
        if (state.m_60734_() != newState.m_60734_() && (tileEntity = world.m_7702_(pos)) instanceof MailboxTileEntity) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((MailboxTileEntity)tileEntity));
        }
        super.m_6810_(state, world, pos, newState, moving);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity tileEntity;
        if (!world.m_5776_() && (tileEntity = world.m_7702_(pos)) instanceof MailboxTileEntity) {
            if (((MailboxTileEntity)tileEntity).isOwner(player)) {
                return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
            player.m_5661_((Component)new TranslatableComponent("msg.furnish.mailbox.no_permission"), true);
        }
        return false;
    }
}

