/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish;

import io.github.wouink.furnish.event.AddArmsToArmorStand;
import io.github.wouink.furnish.event.CyclePainting;
import io.github.wouink.furnish.event.GivePlateToEnderman;
import io.github.wouink.furnish.event.KnockOnDoor;
import io.github.wouink.furnish.event.PlaceCarpet;
import io.github.wouink.furnish.network.ClientMessageHandler;
import io.github.wouink.furnish.network.ItemStackUpdateMessage;
import io.github.wouink.furnish.network.ServerMessageHandler;
import io.github.wouink.furnish.setup.FurnishBlocks;
import io.github.wouink.furnish.setup.FurnishConfig;
import io.github.wouink.furnish.setup.FurnishData;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="furnish")
@Mod.EventBusSubscriber(modid="furnish")
public class Furnish {
    public static final String MODID = "furnish";
    public static final Logger LOG = LogManager.getLogger((String)"Furnish");
    public static final FurnishConfig CONFIG = new FurnishConfig();
    public static SimpleChannel networkChannel;
    public static final String MESSAGE_PROTOCOL_VERSION = "1.0";
    public static final ResourceLocation CHANNEL_LOC;

    public Furnish() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CONFIG.getSpec());
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        FurnishBlocks.setup(bus);
        FurnishData.setup(bus);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register(PlaceCarpet.class);
        MinecraftForge.EVENT_BUS.register(AddArmsToArmorStand.class);
        MinecraftForge.EVENT_BUS.register(CyclePainting.class);
        MinecraftForge.EVENT_BUS.register(KnockOnDoor.class);
        MinecraftForge.EVENT_BUS.register(GivePlateToEnderman.class);
    }

    private void setup(FMLCommonSetupEvent event) {
        networkChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)CHANNEL_LOC, () -> MESSAGE_PROTOCOL_VERSION, ClientMessageHandler::acceptsProtocol, ServerMessageHandler::acceptsProtocol);
        networkChannel.registerMessage(1, ItemStackUpdateMessage.class, ItemStackUpdateMessage::encode, ItemStackUpdateMessage::decode, ServerMessageHandler::onMessageReceived, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        FurnishBlocks.clientSetup();
        FurnishData.clientSetup();
    }

    static {
        CHANNEL_LOC = new ResourceLocation(MODID, "net");
    }
}

