/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.sculkybits.block.entity.custom;

import com.kaboomroads.sculkybits.block.entity.custom.SculkAttackBlockEntity;
import com.kaboomroads.sculkybits.block.entity.custom.SculkAttacker;
import com.kaboomroads.sculkybits.util.Utils;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class SculkBiterBlockEntity
extends SculkAttackBlockEntity {
    public SculkBiterBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    public void onLoad() {
        super.onLoad();
        this.updateState();
    }

    public static void tickAnimation(Level level, BlockPos blockPos, BlockState blockState, SculkBiterBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        List<LivingEntity> attackEntities = SculkAttacker.getAttackEntities(level, blockEntity);
        boolean entities = !attackEntities.isEmpty();
        blockEntity.tickStart(level, blockPos, blockState, attackEntities);
        boolean increment = false;
        if (!entities && blockEntity.getAnimationState() != 0) {
            SculkBiterBlockEntity.increment(blockEntity, 1);
        } else if (entities) {
            for (LivingEntity livingEntity : attackEntities) {
                if (!Utils.entityIsDamageable((Entity)livingEntity) || !SculkAttacker.testAttackable((Entity)livingEntity)) continue;
                increment = true;
                if (!IntStream.of(blockEntity.getAnimationDamageTicks()).anyMatch(i -> i == blockEntity.getAnimationState())) continue;
                blockEntity.tickOnFound(level, blockPos, blockState, livingEntity);
                SculkAttacker.sculkDamage(livingEntity);
            }
            if (increment || blockEntity.getAnimationState() != 0) {
                SculkBiterBlockEntity.increment(blockEntity, 1);
            }
        }
        blockEntity.tickEnd(level, blockPos, blockState, increment);
    }

    public static void increment(SculkAttackBlockEntity blockEntity, int amount) {
        SculkAttackBlockEntity.incrementAnimation(blockEntity, amount);
        blockEntity.updateState();
    }

    public void tickStart(Level level, BlockPos blockPos, BlockState blockState, List<? extends Entity> entities) {
    }

    public void tickOnFound(Level level, BlockPos blockPos, BlockState blockState, LivingEntity entity) {
    }

    public void tickEnd(Level level, BlockPos blockPos, BlockState blockState, boolean increment) {
    }

    @Override
    public double getLevelX() {
        return (double)this.f_58858_.m_123341_() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.f_58858_.m_123342_() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.f_58858_.m_123343_() + 0.5;
    }
}

