/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.sculkybits.util;

import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class MathUtils {
    public static int randomInt(int minInclusive, int maxInclusive) {
        return (int)(Math.random() * (double)(maxInclusive + 1 - minInclusive) + (double)minInclusive);
    }

    public static double randomNum(double min, double max) {
        return Math.random() * (max - min) + min;
    }

    public static double loopClamp(double num, double min, double max) {
        if (num > max) {
            num %= max;
        }
        if (num < min) {
            num = max - Math.abs(num) % max;
        }
        return num;
    }

    public static float loopClamp(float num, float min, float max) {
        if (num > max) {
            num %= max;
        }
        if (num < min) {
            num = max - Math.abs(num) % max;
        }
        return num;
    }

    public static int loopClamp(int num, int min, int max) {
        if (num > max) {
            num = num % max - 1;
        }
        if (num < min) {
            num = max - Math.abs(num) % max;
        }
        return num;
    }

    public static float interpolateLinear(float from, float to, float speed) {
        if (Math.abs(from - to) > speed) {
            return from + speed * Math.signum(to - from);
        }
        return to;
    }

    public static double interpolateLinear(double from, double to, double speed) {
        if (Math.abs(from - to) > speed) {
            return from + speed * Math.signum(to - from);
        }
        return to;
    }

    public static double randomNegative(double num, RandomSource random) {
        if (random.m_188499_()) {
            return -num;
        }
        return num;
    }

    public static int randomNegative(int num, RandomSource random) {
        if (random.m_188499_()) {
            return -num;
        }
        return num;
    }

    public static Vec3 generateRandomVec(double offset) {
        return new Vec3(MathUtils.randomNum(-offset, offset), MathUtils.randomNum(-offset, offset), MathUtils.randomNum(-offset, offset));
    }

    public static Vec3i generateRandomVec(int offset) {
        return new Vec3i(MathUtils.randomInt(-offset, offset), MathUtils.randomInt(-offset, offset), MathUtils.randomInt(-offset, offset));
    }

    public static Vec3i generateRandomNormal(RandomSource random) {
        Vec3i vec3 = MathUtils.generateRandomVec(1);
        if (vec3.m_123341_() == 0 && vec3.m_123342_() == 0 && vec3.m_123343_() == 0) {
            switch (MathUtils.randomInt(0, 2)) {
                case 0: {
                    vec3 = new Vec3i(MathUtils.randomNegative(1, random), 0, 0);
                    break;
                }
                case 1: {
                    vec3 = new Vec3i(0, MathUtils.randomNegative(1, random), 0);
                    break;
                }
                case 2: {
                    vec3 = new Vec3i(0, 0, MathUtils.randomNegative(1, random));
                }
            }
        }
        return vec3;
    }

    public static Vec3i generateRandomNormal2d(RandomSource random) {
        Vec3i vec3 = MathUtils.generateRandomVec(1);
        if (vec3.m_123341_() == 0 && vec3.m_123343_() == 0) {
            vec3 = random.m_188499_() ? new Vec3i(MathUtils.randomNegative(1, random), 0, 0) : new Vec3i(0, 0, MathUtils.randomNegative(1, random));
        }
        return new Vec3i(vec3.m_123341_(), 0, vec3.m_123343_());
    }
}

