/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.sculkybits.event;

import com.kaboomroads.sculkybits.block.custom.override.ModSculkBlock;
import com.kaboomroads.sculkybits.effect.ModEffects;
import com.kaboomroads.sculkybits.entity.ModEntityTypes;
import com.kaboomroads.sculkybits.entity.custom.SculkSaprophyte;
import com.kaboomroads.sculkybits.gamerule.ModGameRules;
import com.kaboomroads.sculkybits.util.EchoPower;
import com.kaboomroads.sculkybits.util.MathUtils;
import com.kaboomroads.sculkybits.util.ModDamageSource;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sculkybits")
public class ModEvents {
    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.f_19853_.f_46443_) {
            return;
        }
        if (event.getSource() != ModDamageSource.SCULK && entity.m_21023_((MobEffect)ModEffects.SCULK.get())) {
            float multiplier = (float)entity.m_21124_((MobEffect)ModEffects.SCULK.get()).m_19564_() * 0.75f + 1.0f;
            event.setAmount(event.getAmount() * multiplier);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.f_19853_;
        if (level.f_46443_) {
            return;
        }
        if ((event.getSource() == ModDamageSource.SCULK_ATTACK || event.getSource() == ModDamageSource.SCULK) && entity.m_6095_() != ModEntityTypes.SCULK_SAPROPHYTE.get()) {
            int amount;
            int n = amount = ModGameRules.RULE_SCULK_SAPROPHYTE_MOB_COUNT != null ? level.m_46469_().m_46215_(ModGameRules.RULE_SCULK_SAPROPHYTE_MOB_COUNT) : 1;
            if (entity.m_6095_() == EntityType.f_20532_) {
                amount = ModGameRules.RULE_SCULK_SAPROPHYTE_PLAYER_COUNT != null ? level.m_46469_().m_46215_(ModGameRules.RULE_SCULK_SAPROPHYTE_PLAYER_COUNT) : 3;
            }
            for (int i = amount; i > 0; --i) {
                SculkSaprophyte sculkSaprophyte = new SculkSaprophyte((EntityType<? extends Monster>)((EntityType)ModEntityTypes.SCULK_SAPROPHYTE.get()), level);
                sculkSaprophyte.m_146884_(entity.m_20318_(1.0f));
                sculkSaprophyte.m_20256_(new Vec3(MathUtils.randomNum(-0.1, 0.1), 0.0, MathUtils.randomNum(-0.1, 0.1)));
                level.m_7967_((Entity)sculkSaprophyte);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        ServerLevel serverLevel;
        Player player = event.getPlayer();
        BlockState blockState = event.getState();
        Block block = blockState.m_60734_();
        BlockPos pos = event.getPos();
        LevelAccessor level = event.getLevel();
        ItemStack item = player.m_21206_();
        if (level.m_5776_()) {
            return;
        }
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_46469_().m_46207_(GameRules.f_46136_)) {
            if (item.m_150930_(Items.f_220224_) && EchoPower.ECHO_POWER.containsKey(block) && item.m_41613_() - EchoPower.ECHO_POWER.get(block) >= 0 && blockState.m_61138_((Property)ModSculkBlock.IS_NATURAL) && ((Boolean)blockState.m_61143_((Property)ModSculkBlock.IS_NATURAL)).booleanValue()) {
                item.m_41774_(EchoPower.ECHO_POWER.get(block).intValue());
            } else if (blockState.m_61138_((Property)ModSculkBlock.IS_NATURAL) && ((Boolean)blockState.m_61143_((Property)ModSculkBlock.IS_NATURAL)).booleanValue()) {
                event.setCanceled(true);
                level.m_46953_(pos, false, (Entity)player);
            }
        }
    }
}

