/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.sculkybits.block.entity.custom.renderer;

import com.kaboomroads.sculkybits.block.entity.custom.SculkFeelerBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

@OnlyIn(value=Dist.CLIENT)
public class SculkFeelerRenderer
implements BlockEntityRenderer<SculkFeelerBlockEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("sculkybits", "sculk_feeler"), "main");
    private final ModelPart body;
    private final ModelPart tendril1;
    private final ModelPart tendril2;
    private final ModelPart tendril3;
    private final ModelPart tendril4;
    private final ModelPart tendril5;
    private final ModelPart tendril6;
    private final ModelPart tendril7;
    private final ModelPart tendril8;
    private final ModelPart tentacle;
    private final BlockEntityRendererProvider.Context context;

    public SculkFeelerRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
        ModelPart root = context.m_173582_(LAYER_LOCATION);
        this.body = root.m_171324_("body");
        this.tendril1 = root.m_171324_("tendril1");
        this.tendril2 = root.m_171324_("tendril2");
        this.tendril3 = root.m_171324_("tendril3");
        this.tendril4 = root.m_171324_("tendril4");
        this.tendril5 = root.m_171324_("tendril5");
        this.tendril6 = root.m_171324_("tendril6");
        this.tendril7 = root.m_171324_("tendril7");
        this.tendril8 = root.m_171324_("tendril8");
        this.tentacle = root.m_171324_("tentacle");
    }

    public void render(@NotNull SculkFeelerBlockEntity blockEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)new ResourceLocation("sculkybits", "textures/block/sculk_feeler.png")));
        poseStack.m_85836_();
        float length = Math.lerp((float)blockEntity.lengthO, (float)blockEntity.length, (float)0.5f);
        poseStack.m_85837_(0.5, -0.5, 0.5);
        this.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, length, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.0f, 1.0f, -7.0f, 14.0f, 1.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(0, 15).m_171488_(-6.0f, 0.0f, -6.0f, 12.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(0, 12).m_171488_(-2.0f, -1.0f, -3.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 10).m_171488_(-2.0f, -1.0f, 2.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 5).m_171488_(-3.0f, -1.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(2.0f, -1.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)0.0f));
        PartDefinition tendril1 = partdefinition.m_171599_("tendril1", CubeListBuilder.m_171558_().m_171514_(8, 21).m_171488_(-0.5f, 10.0f, -2.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)10.0f, (float)-3.5f));
        tendril1.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(4, 21).m_171488_(-0.5f, -2.0f, -1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)-1.5f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition tendril2 = partdefinition.m_171599_("tendril2", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-3.5f, 10.0f, -2.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)10.0f, (float)-3.5f));
        tendril2.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(8, 18).m_171488_(-0.5f, -2.0f, -1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)10.0f, (float)-1.5f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition tendril3 = partdefinition.m_171599_("tendril3", CubeListBuilder.m_171558_().m_171514_(4, 18).m_171488_(-7.5f, 10.0f, 1.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)10.0f, (float)-3.5f));
        tendril3.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.0f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.5f, (float)10.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition tendril4 = partdefinition.m_171599_("tendril4", CubeListBuilder.m_171558_().m_171514_(8, 15).m_171488_(-7.5f, 10.0f, 1.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)10.0f, (float)-0.5f));
        tendril4.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(4, 15).m_171488_(-1.0f, -2.0f, 2.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.5f, (float)10.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition tendril5 = partdefinition.m_171599_("tendril5", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-0.5f, 10.0f, 8.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)10.0f, (float)-3.5f));
        tendril5.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(10, 9).m_171488_(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)8.5f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition tendril6 = partdefinition.m_171599_("tendril6", CubeListBuilder.m_171558_().m_171514_(10, 6).m_171488_(-0.5f, 10.0f, 8.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)10.0f, (float)-3.5f));
        tendril6.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(10, 3).m_171488_(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)8.5f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition tendril7 = partdefinition.m_171599_("tendril7", CubeListBuilder.m_171558_().m_171514_(10, 0).m_171488_(1.5f, 10.0f, 6.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)10.0f, (float)-5.5f));
        tendril7.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(6, 5).m_171488_(0.0f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)10.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition tendril8 = partdefinition.m_171599_("tendril8", CubeListBuilder.m_171558_().m_171514_(6, 0).m_171488_(1.5f, 10.0f, 3.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)10.0f, (float)-5.5f));
        tendril8.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171488_(0.0f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)10.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        partdefinition.m_171599_("tentacle", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-0.5f, -16.0f, -0.5f, 1.0f, 16.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float length, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tendril1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tendril2.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tendril3.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tendril4.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tendril5.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tendril6.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tendril7.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tendril8.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        if (length != 0.0f) {
            poseStack.m_85836_();
            float offset = 0.125f;
            poseStack.m_85841_(1.0f, length, 1.0f);
            poseStack.m_85837_(0.0, ((double)(-length - length + length / 2.0f) + 1.5 - (double)offset) / (double)length, 0.0);
            this.tentacle.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85849_();
        }
    }
}

