/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.sculkybits.block.entity.custom;

import com.kaboomroads.sculkybits.block.custom.SculkNestBlock;
import com.kaboomroads.sculkybits.block.entity.ModBlockEntities;
import com.kaboomroads.sculkybits.block.entity.custom.SculkAttacker;
import com.kaboomroads.sculkybits.entity.ModEntityTypes;
import com.kaboomroads.sculkybits.entity.custom.SculkCrawler;
import com.kaboomroads.sculkybits.gamerule.ModGameRules;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SculkShriekerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationListener;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SculkNestBlockEntity
extends BlockEntity
implements VibrationListener.VibrationListenerConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private VibrationListener listener;

    public static VoxelShape getRadius(float radius) {
        return Block.m_49796_((double)(-radius * 16.0f), (double)(-radius * 16.0f), (double)(-radius * 16.0f), (double)(radius * 16.0f), (double)(radius * 16.0f), (double)(radius * 16.0f));
    }

    public SculkNestBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.SCULK_NEST.get(), pos, blockState);
        this.listener = new VibrationListener((PositionSource)new BlockPositionSource(this.f_58858_), 8, (VibrationListener.VibrationListenerConfig)this);
    }

    public void trySpawn(ServerLevel level, @Nullable ServerPlayer player) {
        BlockPos pos = this.m_58899_();
        if (player == null || ((Boolean)this.m_58900_().m_61143_((Property)SculkNestBlock.INACTIVE)).booleanValue()) {
            return;
        }
        SculkCrawler crawler = (SculkCrawler)((EntityType)ModEntityTypes.SCULK_CRAWLER.get()).m_20615_((Level)level);
        if (crawler == null) {
            return;
        }
        int i = 0;
        VoxelShape spiderRadius = SculkNestBlockEntity.getRadius(ModGameRules.RULE_SCULK_NEST_RANGE != null ? ((ModGameRules.FloatValue)level.m_46469_().m_46170_(ModGameRules.RULE_SCULK_NEST_RANGE)).get() : 10.0f);
        int amount = ModGameRules.RULE_SCULK_NEST_LIMIT != null ? ((GameRules.IntegerValue)level.m_46469_().m_46170_(ModGameRules.RULE_SCULK_NEST_LIMIT)).m_46288_() : 3;
        for (LivingEntity entity : SculkAttacker.getAttackEntities((Level)level, spiderRadius, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))) {
            if (entity.m_6095_() != ModEntityTypes.SCULK_CRAWLER.get() || ++i < amount) continue;
            return;
        }
        level.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SculkNestBlock.INACTIVE, (Comparable)Boolean.valueOf(true)), 2);
        level.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), 200);
        crawler.m_146884_(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5));
        level.m_7967_((Entity)crawler);
    }

    public VibrationListener getListener() {
        return this.listener;
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("listener", 10)) {
            VibrationListener.m_223781_((VibrationListener.VibrationListenerConfig)this).parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_222864_ -> {
                this.listener = p_222864_;
            });
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        VibrationListener.m_223781_((VibrationListener.VibrationListenerConfig)this).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.listener).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_222871_ -> tag.m_128365_("listener", p_222871_));
    }

    @NotNull
    public TagKey<GameEvent> m_213929_() {
        return GameEventTags.f_215854_;
    }

    public boolean m_213641_(@NotNull ServerLevel p_222856_, @NotNull GameEventListener p_222857_, @NotNull BlockPos p_222858_, @NotNull GameEvent p_222859_, @NotNull GameEvent.Context p_222860_) {
        return !this.m_58901_() && SculkShriekerBlockEntity.m_222861_((Entity)p_222860_.f_223711_()) != null;
    }

    public void m_213991_(@NotNull ServerLevel p_222848_, @NotNull GameEventListener p_222849_, @NotNull BlockPos p_222850_, @NotNull GameEvent p_222851_, @Nullable Entity p_222852_, @Nullable Entity p_222853_, float p_222854_) {
        this.trySpawn(p_222848_, SculkShriekerBlockEntity.m_222861_((Entity)(p_222853_ != null ? p_222853_ : p_222852_)));
    }
}

