/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.sculkybits.block.entity.custom;

import com.kaboomroads.sculkybits.block.custom.SculkLurerBlock;
import com.kaboomroads.sculkybits.block.entity.ModBlockEntities;
import com.kaboomroads.sculkybits.block.entity.custom.SculkAttacker;
import com.kaboomroads.sculkybits.block.entity.custom.SculkBiterBlockEntity;
import com.kaboomroads.sculkybits.gamerule.ModGameRules;
import com.kaboomroads.sculkybits.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SculkLurerBlockEntity
extends SculkBiterBlockEntity {
    public static final VoxelShape ATTACK_SHAPE = Block.m_49796_((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);

    public SculkLurerBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.SCULK_LURER.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, SculkLurerBlockEntity blockEntity) {
        float range;
        if (level.f_46443_) {
            return;
        }
        SculkLurerBlockEntity.tickAnimation(level, blockPos, blockState, blockEntity);
        float f = range = ModGameRules.RULE_SCULK_LURER_RANGE != null ? ((ModGameRules.FloatValue)level.m_46469_().m_46170_(ModGameRules.RULE_SCULK_LURER_RANGE)).get() : 5.0f;
        if (range > 0.0f && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (Entity entity : serverLevel.m_142646_().m_142273_()) {
                Vec3 entityLoc;
                Vec3 vecPos = new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
                if (!(Utils.distanceSquared(vecPos, entityLoc = entity.m_20318_(1.0f)) <= range * range) || !(entity instanceof PathfinderMob)) continue;
                PathfinderMob pathfinderMob = (PathfinderMob)entity;
                if (!SculkAttacker.testAttackable(entity)) continue;
                Vec3 offset = entityLoc.m_82546_(vecPos);
                if (offset.m_82556_() != 0.0) {
                    offset = offset.m_82541_().m_82542_(3.0, 1.0, 3.0);
                }
                pathfinderMob.m_21573_().m_26519_((double)blockPos.m_123341_() - offset.f_82479_, (double)blockPos.m_123342_() - offset.f_82480_, (double)blockPos.m_123343_() - offset.f_82481_, 1.0);
            }
        }
    }

    @Override
    public VoxelShape getAttackShape() {
        return ATTACK_SHAPE;
    }

    @Override
    public void updateState() {
        BlockState blockState = this.m_58900_();
        BlockPos blockPos = this.m_58899_();
        switch (this.getAnimationState()) {
            case 1: 
            case 6: {
                this.f_58857_.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)SculkLurerBlock.ANIMATION_STATE, (Comparable)Integer.valueOf(1)), 3);
                break;
            }
            case 2: 
            case 5: {
                this.f_58857_.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)SculkLurerBlock.ANIMATION_STATE, (Comparable)Integer.valueOf(2)), 3);
                break;
            }
            case 3: 
            case 4: {
                this.f_58857_.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)SculkLurerBlock.ANIMATION_STATE, (Comparable)Integer.valueOf(3)), 3);
                break;
            }
            case 11: 
            case 16: {
                this.f_58857_.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)SculkLurerBlock.ANIMATION_STATE, (Comparable)Integer.valueOf(4)), 3);
                break;
            }
            case 12: 
            case 15: {
                this.f_58857_.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)SculkLurerBlock.ANIMATION_STATE, (Comparable)Integer.valueOf(5)), 3);
                break;
            }
            case 13: 
            case 14: {
                this.f_58857_.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)SculkLurerBlock.ANIMATION_STATE, (Comparable)Integer.valueOf(6)), 3);
                break;
            }
            default: {
                this.f_58857_.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)SculkLurerBlock.ANIMATION_STATE, (Comparable)Integer.valueOf(0)), 3);
            }
        }
    }

    @Override
    public int getAnimationLength() {
        return 19;
    }

    @Override
    public int[] getAnimationDamageTicks() {
        return new int[]{0, 10};
    }
}

