/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.sculkybits.util;

import com.kaboomroads.sculkybits.fluid.ModFluids;
import com.kaboomroads.sculkybits.util.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Utils {
    public static int getHighestBlockYAt(Level level, int x, int z) {
        return level.m_6325_(x >> 4, z >> 4).m_5885_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
    }

    public static BlockState getHighestBlockAt(Level level, int x, int z) {
        return level.m_8055_(new BlockPos(x, Utils.getHighestBlockYAt(level, x, z), z));
    }

    public static void maybeDisableShield(Mob mob, Player player, ItemStack itemStack1, ItemStack itemStack2) {
        if (!itemStack1.m_41619_() && !itemStack2.m_41619_() && itemStack1.m_41720_() instanceof AxeItem && itemStack2.m_150930_(Items.f_42740_)) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)mob) * 0.05f;
            if (ThreadLocalRandom.current().nextFloat() < f) {
                player.m_36335_().m_41524_(Items.f_42740_, 100);
                mob.f_19853_.m_7605_((Entity)player, (byte)30);
            }
        }
    }

    public static <T> T rObject(List<T> list) {
        return list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    public static boolean spawnNext(LevelAccessor levelAccessor, BlockState blockState, BlockPos pos) {
        BlockState s;
        BlockPos p;
        List directions = HorizontalDirectionalBlock.f_54117_.m_6908_().stream().toList();
        List all = BlockStateProperties.f_61372_.m_6908_().stream().toList();
        ArrayList<Direction> possibleDirections = new ArrayList<Direction>();
        for (Direction d : directions) {
            p = pos.m_121945_(d);
            s = levelAccessor.m_8055_(p);
            if (!s.m_60713_(Blocks.f_220855_) || !levelAccessor.m_8055_(p.m_7494_()).m_60795_()) continue;
            possibleDirections.add(d);
        }
        for (Direction d : all) {
            p = pos.m_121945_(d);
            s = levelAccessor.m_8055_(p);
            if (d != Direction.UP && s.m_60795_()) {
                return false;
            }
            if (!s.m_204336_(BlockTags.f_215824_)) continue;
            levelAccessor.m_7731_(p, Blocks.f_220855_.m_49966_(), 3);
        }
        if (!possibleDirections.isEmpty()) {
            Direction direction = (Direction)Utils.rObject(possibleDirections);
            BlockPos relativePos = pos.m_121945_(direction);
            for (Direction d : all) {
                BlockPos p2 = relativePos.m_121945_(d);
                BlockState s2 = levelAccessor.m_8055_(p2);
                if (s2.m_204336_(BlockTags.f_215824_)) {
                    levelAccessor.m_7731_(p2, Blocks.f_220855_.m_49966_(), 3);
                    continue;
                }
                if (!s2.m_60795_()) continue;
                return true;
            }
            levelAccessor.m_7731_(relativePos, ((LiquidBlock)ModFluids.SCULK_FLUID_BLOCK.get()).m_49966_(), 3);
        }
        return true;
    }

    public static List<Entity> getNearbyEntities(ServerLevel level, AABB bb, Predicate<Entity> filter) {
        Iterable entityList = level.m_142646_().m_142273_();
        Iterator var7 = entityList.iterator();
        ArrayList<Entity> returnList = new ArrayList<Entity>();
        while (var7.hasNext()) {
            Entity entity = (Entity)var7.next();
            if (filter != null && !filter.test(entity) || !bb.m_82381_(entity.m_20191_())) continue;
            returnList.add(entity);
        }
        return returnList;
    }

    public static Direction getRandomDirectionDependingOnBlocksAroundTheBlockPosition(LevelAccessor levelAccessor, BlockPos pos, Collection<Direction> possibleDirections, Predicate<BlockState> predicate) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        for (Direction direction : possibleDirections) {
            BlockState state = levelAccessor.m_8055_(pos.m_121945_(direction));
            if (!predicate.test(state)) continue;
            directions.add(direction);
        }
        if (directions.isEmpty()) {
            return null;
        }
        return (Direction)Utils.rObject(directions);
    }

    public static Vec3 directionToVector(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> new Vec3(0.0, 1.0, 0.0);
            case Direction.DOWN -> new Vec3(0.0, -1.0, 0.0);
            case Direction.NORTH -> new Vec3(0.0, 0.0, -1.0);
            case Direction.SOUTH -> new Vec3(0.0, 0.0, 1.0);
            case Direction.EAST -> new Vec3(1.0, 0.0, 0.0);
            case Direction.WEST -> new Vec3(-1.0, 0.0, 0.0);
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean entityIsDamageable(Entity entity) {
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!livingEntity.m_6084_()) return false;
        if (livingEntity.m_20147_()) return false;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_150110_().f_35934_) return true;
        }
        if (livingEntity instanceof Player) return false;
        return true;
    }

    public static int getPackedLight(Level level, BlockPos blockPos) {
        return level != null ? LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos) : 0xF000F0;
    }

    public static void spreadSculk(BlockPos pos, ServerLevel level, RandomSource source, int charge, int spread, int minDistMult, int maxDistMult, SculkSpreader spreader, boolean calculateHeight) {
        int i;
        Vec3i vec3 = MathUtils.generateRandomNormal2d().m_142393_(MathUtils.randomInt(minDistMult, maxDistMult));
        pos = pos.m_121996_(vec3);
        if (calculateHeight) {
            pos = Utils.getCorrectHeightPos(pos, level);
        }
        for (i = charge; i > 0; --i) {
            spreader.m_222283_().add(new SculkSpreader.ChargeCursor(pos, charge));
        }
        for (i = spread; i > 0; --i) {
            spreader.m_222255_((LevelAccessor)level, pos, source, true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BlockPos getCorrectHeightPos(BlockPos pPos, ServerLevel level) {
        BlockPos pos = new BlockPos((Vec3i)pPos);
        while (true) {
            BlockState blockState = level.m_8055_(pos);
            BlockState blockStateUnder = level.m_8055_(pos.m_121996_(new Vec3i(0, 1, 0)));
            BlockState blockStateAbove = level.m_8055_(pos.m_121996_(new Vec3i(0, -1, 0)));
            if (blockState.m_60795_()) {
                if (!blockStateUnder.m_60795_()) return pos;
                pos = pos.m_121996_(new Vec3i(0, 1, 0));
                continue;
            }
            pos = pos.m_121996_(new Vec3i(0, -1, 0));
            if (blockStateAbove.m_60795_()) return pos;
        }
    }

    public static void spreadSculk(BlockPos pos, ServerLevel level, RandomSource source, int charge, int spread, int minDistMult, int maxDistMult) {
        int i;
        SculkSpreader spreader = SculkSpreader.m_222254_();
        Vec3i vec3 = MathUtils.generateRandomNormal2d().m_142393_(MathUtils.randomInt(minDistMult, maxDistMult));
        pos = pos.m_121996_(vec3);
        for (i = charge; i > 0; --i) {
            spreader.m_222283_().add(new SculkSpreader.ChargeCursor(pos, charge));
        }
        for (i = spread; i > 0; --i) {
            spreader.m_222255_((LevelAccessor)level, pos, source, true);
        }
    }

    public static void spreadSculk(BlockPos pos, ServerLevel level, RandomSource source, int charge, int spread) {
        Utils.spreadSculk(pos, level, source, charge, spread, 5, 10);
    }

    public static List<ServerPlayer> addEffectToPlayersAround(ServerLevel level, @Nullable Entity entity, Vec3 vec3, double radius, MobEffectInstance mobEffectInstance, boolean checkHasEffect, boolean overrideEffect, boolean checkGameMode) {
        MobEffect mobeffect = mobEffectInstance.m_19544_();
        List list = level.m_8795_(player -> !(checkGameMode && !player.f_8941_.m_9294_() || entity != null && entity.m_7307_((Entity)player) || checkHasEffect && player.m_21023_(mobeffect) || !vec3.m_82509_((Position)player.m_20182_(), radius) || player.m_21023_(mobeffect) && overrideEffect && player.m_21124_(mobeffect).m_19564_() >= mobEffectInstance.m_19564_() && player.m_21124_(mobeffect).m_19557_() >= mobEffectInstance.m_19557_()));
        list.forEach(player -> player.m_147207_(new MobEffectInstance(mobEffectInstance), entity));
        return list;
    }

    public static LivingEntity addEffect(LivingEntity livingEntity, @Nullable Entity entity, MobEffectInstance mobEffectInstance, boolean checkHasEffect, boolean overrideEffect) {
        MobEffect mobeffect = mobEffectInstance.m_19544_();
        if (!(entity != null && entity.m_7307_((Entity)livingEntity) || livingEntity.m_21023_(mobeffect) && overrideEffect && checkHasEffect && livingEntity.m_21124_(mobeffect).m_19564_() >= mobEffectInstance.m_19564_() && livingEntity.m_21124_(mobeffect).m_19557_() >= mobEffectInstance.m_19557_())) {
            livingEntity.m_147207_(new MobEffectInstance(mobEffectInstance), entity);
        }
        return livingEntity;
    }

    public static float distance(Vec3 pos1, Vec3 pos2) {
        float f = (float)(pos1.f_82479_ - pos2.f_82479_);
        float f1 = (float)(pos1.f_82480_ - pos2.f_82480_);
        float f2 = (float)(pos1.f_82481_ - pos2.f_82481_);
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static float distanceSquared(Vec3 pos1, Vec3 pos2) {
        float f = (float)(pos1.f_82479_ - pos2.f_82479_);
        float f1 = (float)(pos1.f_82480_ - pos2.f_82480_);
        float f2 = (float)(pos1.f_82481_ - pos2.f_82481_);
        return f * f + f1 * f1 + f2 * f2;
    }
}

