/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.sculkybits.block.custom.override;

import com.kaboomroads.sculkybits.block.ModBlocks;
import com.kaboomroads.sculkybits.block.custom.SculkAbsorberBlock;
import com.kaboomroads.sculkybits.block.custom.SculkStabberBlock;
import com.kaboomroads.sculkybits.fluid.ModFluids;
import com.kaboomroads.sculkybits.util.Pair;
import com.kaboomroads.sculkybits.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SculkBlock;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModSculkBlock
extends SculkBlock {
    public static final BooleanProperty IS_NATURAL = BooleanProperty.m_61465_((String)"natural");

    public ModSculkBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public int chargeMultiplier() {
        return 5;
    }

    public int costOverride(Level level) {
        return 1;
    }

    public int costOverride() {
        return 1;
    }

    public boolean overrideCost(Level level) {
        return false;
    }

    public boolean overrideCost() {
        return false;
    }

    public int m_213628_(SculkSpreader.ChargeCursor cursor, @NotNull LevelAccessor levelAccessor, @NotNull BlockPos pos, @NotNull RandomSource source, @NotNull SculkSpreader sculkSpreader, boolean p_222078_) {
        int i = cursor.m_222341_();
        Level level = null;
        if (levelAccessor instanceof Level) {
            Level l;
            level = l = (Level)levelAccessor;
        }
        if (i != 0 && source.m_188503_(sculkSpreader.m_222280_()) == 0) {
            BlockPos blockpos = cursor.m_222304_();
            boolean flag = blockpos.m_123314_((Vec3i)pos, (double)sculkSpreader.m_222279_());
            if (!flag && ModSculkBlock.canPlaceGrowth(levelAccessor, blockpos)) {
                int j = sculkSpreader.m_222278_();
                if (level != null) {
                    if (this.overrideCost(level)) {
                        j = this.costOverride(level);
                    }
                } else if (this.overrideCost()) {
                    j = this.costOverride();
                }
                if (j <= 0 || source.m_188503_(j) < i * this.chargeMultiplier()) {
                    BlockPos blockpos1 = blockpos.m_7494_();
                    Pair<BlockState, BlockPos> pair = this.getRandomGrowthState(levelAccessor, blockpos1, source, sculkSpreader.m_222282_());
                    BlockState blockstate = (BlockState)pair.first;
                    blockpos1 = (BlockPos)pair.second;
                    levelAccessor.m_7731_(blockpos1, blockstate, 3);
                    levelAccessor.m_5594_(null, blockpos, blockstate.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return Math.max(0, i - j);
            }
            return source.m_188503_(sculkSpreader.m_222281_()) != 0 ? i : i - (flag ? 1 : ModSculkBlock.getDecayPenalty(sculkSpreader, blockpos, pos, i));
        }
        return i;
    }

    public static boolean canPlaceGrowth(LevelAccessor levelAccessor, BlockPos pos) {
        BlockState blockstate = levelAccessor.m_8055_(pos.m_7494_());
        if (blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_49990_) && blockstate.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            int i = 0;
            for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, 0, -4), (BlockPos)pos.m_7918_(4, 2, 4))) {
                BlockState blockstate1 = levelAccessor.m_8055_(blockpos);
                if (blockstate1.m_60713_(Blocks.f_152500_) || blockstate1.m_60713_(Blocks.f_220858_)) {
                    ++i;
                }
                if (i <= 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int getDecayPenalty(SculkSpreader sculkSpreader, BlockPos pos, BlockPos pos2, int p_222083_) {
        int i = sculkSpreader.m_222279_();
        float f = Mth.m_14207_((float)((float)Math.sqrt(pos.m_123331_((Vec3i)pos2)) - (float)i));
        int j = Mth.m_144944_((int)(24 - i));
        float f1 = Math.min(1.0f, f / (float)j);
        return Math.max(1, (int)((float)p_222083_ * f1 * 0.5f));
    }

    public Pair<BlockState, BlockPos> getRandomGrowthState(LevelAccessor levelAccessor, BlockPos pos, RandomSource source, boolean isWorldGen) {
        BlockState blockstate = Blocks.f_152500_.m_49966_();
        int nextInt = source.m_188503_(50);
        if (isWorldGen) {
            nextInt = source.m_188503_(56);
        }
        switch (nextInt) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                blockstate = (BlockState)((BlockState)((Block)ModBlocks.SCULK_JAW.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(source))).m_61124_((Property)IS_NATURAL, (Comparable)Boolean.valueOf(true));
                pos = pos.m_7495_();
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                blockstate = (BlockState)((Block)ModBlocks.SCULK_LURKER.get()).m_49966_().m_61124_((Property)IS_NATURAL, (Comparable)Boolean.valueOf(true));
                pos = pos.m_7495_();
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                blockstate = (BlockState)((Block)ModBlocks.SCULK_TRAP.get()).m_49966_().m_61124_((Property)IS_NATURAL, (Comparable)Boolean.valueOf(true));
                pos = pos.m_7495_();
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                blockstate = isWorldGen ? (BlockState)Blocks.f_220858_.m_49966_().m_61124_((Property)SculkShriekerBlock.f_222154_, (Comparable)Boolean.valueOf(true)) : Blocks.f_220858_.m_49966_();
                break;
            }
            case 21: {
                blockstate = (BlockState)((Block)ModBlocks.SCULK_RIBS.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(source));
                break;
            }
            case 22: 
            case 23: {
                blockstate = (BlockState)((Block)ModBlocks.SCULK_BONES.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(source));
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                pos = pos.m_7495_();
                blockstate = (BlockState)SculkStabberBlock.getStateForGeneration(levelAccessor, ((Block)ModBlocks.SCULK_STABBER.get()).m_49966_(), pos).m_61124_((Property)IS_NATURAL, (Comparable)Boolean.valueOf(true));
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                pos = pos.m_7495_();
                if (Utils.spawnNext(levelAccessor, blockstate, pos)) {
                    blockstate = ((LiquidBlock)ModFluids.SCULK_FLUID_BLOCK.get()).m_49966_();
                    break;
                }
                blockstate = ((Block)ModBlocks.SCULK_FLESH.get()).m_49966_();
                break;
            }
            case 36: {
                blockstate = (BlockState)((Block)ModBlocks.SCULK_LURER.get()).m_49966_().m_61124_((Property)IS_NATURAL, (Comparable)Boolean.valueOf(true));
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                pos = pos.m_6625_(2);
                BlockState state = levelAccessor.m_8055_(pos);
                if (!state.m_60795_() && !state.m_60713_((Block)ModBlocks.SCULK_VEIN.get()) && !state.m_60713_(Blocks.f_49990_)) break;
                blockstate = (BlockState)((Block)ModBlocks.SCULK_FEELER.get()).m_49966_().m_61124_((Property)IS_NATURAL, (Comparable)Boolean.valueOf(true));
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                if (!isWorldGen) break;
                pos = pos.m_7495_();
                blockstate = (BlockState)SculkAbsorberBlock.getStateForGeneration(levelAccessor, ((Block)ModBlocks.SCULK_ABSORBER.get()).m_49966_(), pos).m_61124_((Property)IS_NATURAL, (Comparable)Boolean.valueOf(true));
            }
        }
        return new Pair<BlockState, BlockPos>(blockstate.m_61138_((Property)BlockStateProperties.f_61362_) && !levelAccessor.m_6425_(pos).m_76178_() ? (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)) : blockstate, pos);
    }

    public static void activateSculk(Level level, BlockPos pos, int radius, @Nullable Entity entity) {
        if (level.f_46443_) {
            return;
        }
        for (int x = pos.m_123341_() - radius; x < pos.m_123341_() + radius; ++x) {
            for (int y = pos.m_123342_() - radius; y < pos.m_123342_() + radius; ++y) {
                for (int z = pos.m_123343_() - radius; z < pos.m_123343_() + radius; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    BlockState blockState = level.m_8055_(blockPos);
                    if (blockState.m_60713_(Blocks.f_152500_)) {
                        SculkSensorBlock.m_222125_((Entity)entity, (Level)level, (BlockPos)blockPos, (BlockState)blockState, (int)SculkSensorBlockEntity.m_222797_((float)80.0f, (int)8));
                    }
                    level.m_141902_(blockPos, BlockEntityType.f_222759_).ifPresent(blockEntity -> {
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            blockEntity.m_222841_(serverLevel, entity instanceof ServerPlayer ? (ServerPlayer)entity : null);
                        }
                    });
                }
            }
        }
    }
}

