/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget.container.tabbed;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.background.EmptyBackground;
import dev.lambdaurora.spruceui.navigation.NavigationDirection;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.widget.SpruceSeparatorWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.WithBackground;
import dev.lambdaurora.spruceui.widget.container.AbstractSpruceParentWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceEntryListWidget;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class SpruceTabbedWidget
extends AbstractSpruceParentWidget<SpruceWidget> {
    private final class_2561 title;
    private final SideTabList list;
    private final Position anchor;
    private boolean isLeft = false;

    public SpruceTabbedWidget(Position position, int width, int height, @Nullable class_2561 title) {
        this(position, width, height, title, Math.max(100, width / 8), title != null ? 20 : 0);
    }

    public SpruceTabbedWidget(Position position, int width, int height, @Nullable class_2561 title, int sideWidth, int sideTopOffset) {
        super(position, SpruceWidget.class);
        this.width = width;
        this.height = height;
        this.title = title;
        this.list = new SideTabList(Position.of(position, 0, sideTopOffset), sideWidth, height - sideTopOffset);
        this.anchor = Position.of(this, this.list.getWidth(), 0);
    }

    public SideTabList getList() {
        return this.list;
    }

    public void addTabEntry(class_2561 title, @Nullable class_2561 description, ContainerFactory factory) {
        this.addTabEntry(title, description, factory.build(this.getWidth() - this.list.getWidth(), this.getHeight()));
    }

    public void addTabEntry(class_2561 title, @Nullable class_2561 description, AbstractSpruceWidget container) {
        TabEntry entry = this.list.addTabEntry(title, description, container);
        entry.container.getPosition().setAnchor(this.anchor);
    }

    public void addSeparatorEntry(class_2561 title) {
        this.list.addSeparatorEntry(title);
    }

    public boolean removeTabEntry(class_2561 title) {
        return this.list.removeTabEntry(title);
    }

    public boolean removeSeparatorEntry(class_2561 title) {
        return this.list.removeSeparatorEntry(title);
    }

    @Override
    public void setFocused(@Nullable SpruceWidget focused) {
        super.setFocused(focused);
    }

    @Override
    public List<SpruceWidget> children() {
        if (this.list.getCurrentTab() == null) {
            return List.of(this.list);
        }
        return List.of(this.list, this.list.getCurrentTab().container);
    }

    @Override
    public boolean onNavigation(NavigationDirection direction, boolean tab) {
        if (this.requiresCursor()) {
            return false;
        }
        if (this.list.getCurrentTab() == null) {
            return super.onNavigation(direction, tab);
        }
        if (tab) {
            boolean result = this.list.getCurrentTab().container.onNavigation(direction, tab);
            this.setFocused(this.list.getCurrentTab().container.isFocused() ? this.list.getCurrentTab().container : null);
            return result;
        }
        if (direction.isHorizontal()) {
            boolean result;
            if (direction == NavigationDirection.RIGHT) {
                if (this.list.getCurrentTab().container.onNavigation(direction, tab)) {
                    this.setFocused(this.list.getCurrentTab().container);
                }
            } else if (this.getFocused() != this.list && !(result = this.list.getCurrentTab().container.onNavigation(direction, tab))) {
                this.setFocused(this.list);
            }
            return true;
        }
        if (!this.isFocused()) {
            this.setFocused(true);
            this.setFocused(this.isLeft ? this.list : this.list.getCurrentTab().container);
        } else {
            boolean bl = this.isLeft = this.getFocused() == this.list;
        }
        if (this.getFocused() == null) {
            this.setFocused(this.isLeft ? this.list : this.list.getCurrentTab().container);
        }
        return this.getFocused().onNavigation(direction, tab);
    }

    @Override
    protected void renderWidget(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.title != null) {
            SpruceTabbedWidget.method_27534((class_4587)matrices, (class_327)this.client.field_1772, (class_2561)this.title, (int)(this.getX() + this.list.getWidth() / 2), (int)(this.getY() + 6), (int)-1);
        }
        this.list.method_25394(matrices, mouseX, mouseY, delta);
        if (this.list.getCurrentTab() != null) {
            this.list.getCurrentTab().container.method_25394(matrices, mouseX, mouseY, delta);
        }
    }

    public static class SideTabList
    extends SpruceEntryListWidget<Entry> {
        private TabEntry currentTab = null;

        protected SideTabList(Position position, int width, int height) {
            super(position, width, height, 0, Entry.class);
            this.setRenderTransition(false);
        }

        public TabEntry getCurrentTab() {
            return this.currentTab;
        }

        @Override
        public void setFocused(boolean focused) {
            super.setFocused(focused);
            if (!focused) {
                this.setSelected(this.currentTab);
            }
        }

        public void setSelected(@Nullable TabEntry tab) {
            if (this.currentTab != null) {
                this.currentTab.selected = false;
            }
            if (tab != null) {
                tab.setFocused(true);
            }
            this.setFocused(tab);
            this.currentTab = tab;
        }

        public TabEntry addTabEntry(class_2561 title, @Nullable class_2561 description, AbstractSpruceWidget container) {
            TabEntry entry = new TabEntry(this, title, description, container);
            this.addEntry(entry);
            if (this.getCurrentTab() == null) {
                this.setSelected(entry);
            }
            return entry;
        }

        public SeparatorEntry addSeparatorEntry(class_2561 title) {
            SeparatorEntry entry = new SeparatorEntry(this, title);
            this.addEntry(entry);
            return entry;
        }

        @Override
        public boolean removeEntry(Entry entry) {
            if (this.getCurrentTab() == entry) {
                this.refocusTabOnRemoval(entry);
            }
            return super.removeEntry(entry);
        }

        public boolean removeTabEntry(class_2561 title) {
            for (Entry entry : this) {
                if (!(entry instanceof TabEntry) || !entry.getTitle().equals(title)) continue;
                return this.removeEntry(entry);
            }
            return false;
        }

        public boolean removeSeparatorEntry(class_2561 title) {
            for (Entry entry : this) {
                if (!(entry instanceof SeparatorEntry) || !entry.getTitle().equals(title)) continue;
                return this.removeEntry(entry);
            }
            return false;
        }

        protected void refocusTabOnRemoval(Entry focused) {
            Entry entry;
            int index;
            int currentIndex = this.children().indexOf(focused);
            for (index = currentIndex - 1; index >= 0; --index) {
                entry = (Entry)this.getEntry(index);
                if (!(entry instanceof TabEntry)) continue;
                TabEntry tabEntry = (TabEntry)entry;
                this.setSelected(tabEntry);
                return;
            }
            for (index = currentIndex + 1; index < this.children().size(); ++index) {
                entry = (Entry)this.getEntry(index);
                if (!(entry instanceof TabEntry)) continue;
                TabEntry tabEntry = (TabEntry)entry;
                this.setSelected(tabEntry);
                return;
            }
            this.setSelected(null);
        }

        @Override
        public boolean onNavigation(NavigationDirection direction, boolean tab) {
            if (this.requiresCursor()) {
                return false;
            }
            Entry old = (Entry)this.getFocused();
            boolean result = super.onNavigation(direction, tab);
            Entry focused = (Entry)this.getFocused();
            if (result && old != focused && focused instanceof TabEntry) {
                TabEntry tabEntry = (TabEntry)focused;
                this.setSelected(tabEntry);
            }
            return result;
        }
    }

    public static interface ContainerFactory {
        public AbstractSpruceWidget build(int var1, int var2);
    }

    public static class TabEntry
    extends Entry {
        private final List<class_5481> title;
        private final List<class_5481> description;
        private final AbstractSpruceWidget container;
        private boolean selected;

        protected TabEntry(SideTabList parent, class_2561 title, @Nullable class_2561 description, AbstractSpruceWidget container) {
            super(parent, title);
            this.title = this.client.field_1772.method_1728((class_5348)title, this.parent.getWidth() - 18);
            this.description = description == null ? null : this.client.field_1772.method_1728((class_5348)description, this.parent.getWidth() - 18);
            this.container = container;
            if (container instanceof SpruceEntryListWidget) {
                SpruceEntryListWidget listWidget = (SpruceEntryListWidget)container;
                listWidget.setAllowOutsideHorizontalNavigation(true);
            }
        }

        @Override
        public int getHeight() {
            int n;
            int n2 = this.title.size();
            Objects.requireNonNull(this.client.field_1772);
            int n3 = 4 + (n2 * 9 + 4);
            if (this.description == null) {
                n = 0;
            } else {
                int n4 = this.description.size();
                Objects.requireNonNull(this.client.field_1772);
                n = n4 * 9 + 4;
            }
            return n3 + n + 4;
        }

        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void setFocused(boolean focused) {
            super.setFocused(focused);
            if (focused) {
                this.selected = true;
            }
        }

        @Override
        protected boolean onMouseClick(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.playDownSound();
                this.parent.setSelected(this);
                return true;
            }
            return false;
        }

        @Override
        protected void renderWidget(class_4587 matrices, int mouseX, int mouseY, float delta) {
            int y = this.getY() + 4;
            for (class_5481 line : this.title) {
                this.client.field_1772.method_27528(matrices, line, (float)(this.getX() + 4), (float)y, 0xFFFFFF);
                y += 9;
            }
            if (this.description != null) {
                y += 4;
                for (class_5481 line : this.description) {
                    this.client.field_1772.method_27528(matrices, line, (float)(this.getX() + 8), (float)y, 0xFFFFFF);
                    y += 9;
                }
            }
        }

        @Override
        protected void renderBackground(class_4587 matrices, int mouseX, int mouseY, float delta) {
            super.renderBackground(matrices, mouseX, mouseY, delta);
            if (this.isFocused() && this.parent.isFocused()) {
                TabEntry.method_25294((class_4587)matrices, (int)this.getX(), (int)this.getY(), (int)(this.getX() + this.getWidth()), (int)(this.getY() + this.getHeight() - 4), (int)0x2FFFFFFF);
            } else if (this.selected || this.isMouseHovered()) {
                TabEntry.method_25294((class_4587)matrices, (int)this.getX(), (int)this.getY(), (int)(this.getX() + this.getWidth()), (int)(this.getY() + this.getHeight() - 4), (int)0x1AFFFFFF);
            }
        }

        public String toString() {
            return "SpruceTabbedWidget$TabEntry{title=" + this.getTitle() + ", description=" + this.description + ", position=" + this.getPosition() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", container=" + this.container + ", selected=" + this.selected + ", background=" + this.getBackground() + "}";
        }
    }

    public static class SeparatorEntry
    extends Entry {
        private final SpruceSeparatorWidget separatorWidget;

        protected SeparatorEntry(SideTabList parent, class_2561 title) {
            super(parent, title);
            this.separatorWidget = new SpruceSeparatorWidget(Position.of(this, 0, 2), this.getWidth(), title){

                @Override
                public int getWidth() {
                    return this.getWidth();
                }
            };
        }

        public SpruceSeparatorWidget getSeparatorWidget() {
            return this.separatorWidget;
        }

        @Override
        public int getHeight() {
            return this.separatorWidget.getHeight() + 6;
        }

        @Override
        public boolean onNavigation(NavigationDirection direction, boolean tab) {
            return this.separatorWidget.onNavigation(direction, tab);
        }

        @Override
        protected void renderWidget(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.separatorWidget.method_25394(matrices, mouseX, mouseY, delta);
        }

        public String toString() {
            return "SpruceTabbedWidget$SeparatorEntry{title=" + this.getTitle() + ", position=" + this.getPosition() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", background=" + this.getBackground() + "}";
        }
    }

    public static abstract class Entry
    extends SpruceEntryListWidget.Entry
    implements WithBackground {
        protected final SideTabList parent;
        private final class_2561 title;
        private Background background = EmptyBackground.EMPTY_BACKGROUND;

        protected Entry(SideTabList parent, class_2561 title) {
            this.parent = parent;
            this.title = title;
        }

        @Override
        public int getWidth() {
            return this.parent.getInnerWidth();
        }

        public class_2561 getTitle() {
            return this.title;
        }

        @Override
        public Background getBackground() {
            return this.background;
        }

        @Override
        public void setBackground(Background background) {
            this.background = background;
        }

        @Override
        protected void renderBackground(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.getBackground().render(matrices, this, 0, mouseX, mouseY, delta);
        }
    }
}

