/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.Tooltip;
import dev.lambdaurora.spruceui.Tooltipable;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.wrapper.VanillaButtonWrapper;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSpruceButtonWidget
extends AbstractSpruceWidget
implements Tooltipable {
    private class_2561 message;
    private class_2561 tooltip;
    private int tooltipTicks;
    private long lastTick;
    protected float alpha = 1.0f;

    public AbstractSpruceButtonWidget(Position position, int width, int height, class_2561 message) {
        super(position);
        this.width = width;
        this.height = height;
        this.message = message;
    }

    public class_2561 getMessage() {
        return this.message;
    }

    public void setMessage(class_2561 message) {
        this.message = message;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float value) {
        this.alpha = value;
    }

    @Override
    public Optional<class_2561> getTooltip() {
        return Optional.ofNullable(this.tooltip);
    }

    @Override
    public void setTooltip(@Nullable class_2561 tooltip) {
        this.tooltip = tooltip;
    }

    public VanillaButtonWrapper asVanilla() {
        return new VanillaButtonWrapper(this);
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    @Override
    protected boolean onMouseClick(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseRelease(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isValidClickButton(button)) {
            this.onDrag(mouseX, mouseY, deltaX, deltaY);
            return true;
        }
        return false;
    }

    protected void onClick(double mouseX, double mouseY) {
    }

    protected void onRelease(double mouseX, double mouseY) {
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
    }

    protected int getVOffset() {
        if (!this.isActive()) {
            return 0;
        }
        return this.isFocusedOrHovered() ? 2 : 1;
    }

    @Override
    protected void renderWidget(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.renderButton(matrices, mouseX, mouseY, delta);
        if (!this.dragging) {
            Tooltip.queueFor(this, mouseX, mouseY, this.tooltipTicks, i -> {
                this.tooltipTicks = i;
            }, this.lastTick, i -> {
                this.lastTick = i;
            });
        }
    }

    protected void renderButton(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int color = this.active ? 0xFFFFFF : 0xA0A0A0;
        AbstractSpruceButtonWidget.method_27534((class_4587)matrices, (class_327)this.client.field_1772, (class_2561)this.getMessage(), (int)(this.getX() + this.getWidth() / 2), (int)(this.getY() + (this.getHeight() - 8) / 2), (int)(color | class_3532.method_15386((float)(this.alpha * 255.0f)) << 24));
    }

    @Override
    protected void renderBackground(class_4587 matrices, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.getAlpha());
        RenderSystem.setShaderTexture((int)0, (class_2960)class_339.field_22757);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        int v = 46 + this.getVOffset() * 20;
        if (this.getWidth() / 2 < 200) {
            this.method_25302(matrices, this.getX(), this.getY(), 0, v, this.getWidth() / 2, this.getHeight());
            this.method_25302(matrices, this.getX() + this.getWidth() / 2, this.getY(), 200 - this.getWidth() / 2, v, this.getWidth() / 2, this.getHeight());
        } else {
            int x;
            int middleWidth = this.getWidth() - 100;
            this.method_25302(matrices, this.getX(), this.getY(), 0, v, 50, this.getHeight());
            for (x = 50; x < middleWidth; x += 100) {
                this.method_25302(matrices, this.getX() + x, this.getY(), 50, v, 100, this.getHeight());
            }
            if (x - middleWidth > 0) {
                this.method_25302(matrices, this.getX() + x, this.getY(), 50, v, x - middleWidth, this.getHeight());
            }
            this.method_25302(matrices, this.getX() + this.getWidth() - 50, this.getY(), 150, v, 50, this.getHeight());
        }
    }

    @Override
    @Nullable
    protected class_2561 getNarrationMessage() {
        return class_2561.method_43469((String)"gui.narrate.button", (Object[])new Object[]{this.getMessage()});
    }

    protected class_2561 getNarrationFocusedUsageMessage() {
        return class_2561.method_43471((String)"narration.button.usage.focused");
    }

    protected class_2561 getNarrationHoveredUsageMessage() {
        return class_2561.method_43471((String)"narration.button.usage.hovered");
    }

    @Override
    public void method_37020(class_6382 builder) {
        super.method_37020(builder);
        if (this.isActive()) {
            if (this.isFocused()) {
                builder.method_37034(class_6381.field_33791, this.getNarrationFocusedUsageMessage());
            } else {
                builder.method_37034(class_6381.field_33791, this.getNarrationHoveredUsageMessage());
            }
        }
        this.getTooltip().ifPresent(text -> builder.method_37034(class_6381.field_33790, text));
    }
}

