/*
 * Decompiled with CFR 0.152.
 */
package moreexplosives.entities;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import moreexplosives.entities.AI.EntityAISuperCreeperSwell;
import moreexplosives.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDynamiteCreeper
extends EntityMob {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityDynamiteCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityDynamiteCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityDynamiteCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> CREEPER_TYPE = EntityDataManager.func_187226_a(EntityDynamiteCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 1;
    private int droppedSkulls;

    public EntityDynamiteCreeper(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.7f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISuperCreeperSwell(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
        this.field_70180_af.func_187214_a(CREEPER_TYPE, (Object)1);
    }

    public static void registerFixesCreeper(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityDynamiteCreeper.class);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            compound.func_74757_a("powered", true);
        }
        compound.func_74777_a("Fuse", (short)this.fuseTime);
        compound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        compound.func_74757_a("ignited", this.hasIgnited());
        compound.func_74768_a("CreeperType", this.getCreeperType());
    }

    public void SetAttributes() {
        this.field_70178_ae = this.getCreeperType() == 3 || this.getCreeperType() == 4 || this.getCreeperType() == 5 || this.getCreeperType() == 8 || this.getCreeperType() == 9;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(POWERED, (Object)compound.func_74767_n("powered"));
        this.setCreeperType(compound.func_74762_e("CreeperType"));
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
        if (compound.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = compound.func_74771_c("ExplosionRadius");
        }
        if (compound.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    public int getCreeperType() {
        return (Integer)this.field_70180_af.func_187225_a(CREEPER_TYPE);
    }

    public void setCreeperType(int rabbitTypeId) {
        this.field_70180_af.func_187227_b(CREEPER_TYPE, (Object)rabbitTypeId);
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.hasIgnited() && this.getCreeperType() == 15 && this.field_70146_Z.nextInt(10) == 0) {
                this.teleportRandomly();
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187570_aq;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            if (cause.func_76346_g() instanceof EntitySkeleton) {
                int i = Item.func_150891_b((Item)Items.field_151096_cd);
                int j = Item.func_150891_b((Item)Items.field_151084_co);
                int k = i + this.field_70146_Z.nextInt(j - i + 1);
                this.func_145779_a(Item.func_150899_d((int)k), 1);
            } else if (cause.func_76346_g() instanceof EntityDynamiteCreeper && cause.func_76346_g() != this && ((EntityDynamiteCreeper)cause.func_76346_g()).getPowered() && ((EntityDynamiteCreeper)cause.func_76346_g()).isAIEnabled()) {
                ((EntityDynamiteCreeper)cause.func_76346_g()).incrementDroppedSkulls();
                this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        return true;
    }

    protected void func_70628_a(boolean par1, int par2) {
        int i = this.field_70146_Z.nextInt(3);
        for (int j = 0; j < i; ++j) {
            if (this.getCreeperType() == 0) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 1) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.super_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 2) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.pink_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 3) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.water_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 4) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.lava_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 5) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.flame_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 6) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.levitation_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 7) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.gravity_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 8) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.trap_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 9) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.thunder_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 10) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.warp_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 11) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.reversewarp_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 12) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.cg_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 13) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.mining_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 14) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.gold_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 15) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.mega_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 16) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.ultra_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 17) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.cloud_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 18) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.time_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 19) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.cake_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 20) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.dirt_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 21) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.stone_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 22) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.clay_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 23) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.ice_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 24) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.snow_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 25) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.sand_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 26) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.redsand_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 27) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.leaf_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 28) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.dirt_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 29) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.stone_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 30) {
                this.func_145779_a(Items.field_151016_H, 1);
                continue;
            }
            if (this.getCreeperType() == 31) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.pink_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() == 32) {
                this.func_145779_a(Items.field_151016_H, 1);
                this.func_145779_a(ModItems.cg_dynamite, 1);
                continue;
            }
            if (this.getCreeperType() != 32) continue;
            this.func_145779_a(Items.field_151016_H, 1);
            this.func_145779_a(ModItems.blue_dynamite, 1);
        }
    }

    public void SetTime() {
        if (this.field_70170_p.func_72935_r()) {
            this.field_70170_p.func_72877_b(15000L);
        } else {
            this.field_70170_p.func_72877_b(100L);
        }
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                this.ignite();
                itemstack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void SmallExplosion() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            this.field_70729_aU = true;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, flag);
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    public void LargeExplosion() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            this.field_70729_aU = true;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 10.0f, flag);
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    public void HugeExplosion() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            this.field_70729_aU = true;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 100.0f, flag);
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    public void SpawnCloud() {
        if (!this.field_70170_p.field_72995_K) {
            EntityOcelot entitypigzombie = new EntityOcelot(this.field_70170_p);
            entitypigzombie.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie);
            EntityOcelot entitypigzombie2 = new EntityOcelot(this.field_70170_p);
            entitypigzombie2.func_70012_b(this.field_70165_t + 1.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie2.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie2.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie2);
            EntityOcelot entitypigzombie3 = new EntityOcelot(this.field_70170_p);
            entitypigzombie3.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie3.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie3.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie3);
            EntityOcelot entitypigzombie4 = new EntityOcelot(this.field_70170_p);
            entitypigzombie4.func_70012_b(this.field_70165_t - 1.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie4.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie4.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie);
            EntityOcelot entitypigzombie5 = new EntityOcelot(this.field_70170_p);
            entitypigzombie5.func_70012_b(this.field_70165_t - 2.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie5.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie5.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie5);
            EntityOcelot entitypigzombie6 = new EntityOcelot(this.field_70170_p);
            entitypigzombie6.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v + 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie6.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie6.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie6);
            EntityOcelot entitypigzombie7 = new EntityOcelot(this.field_70170_p);
            entitypigzombie7.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie7.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie7.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie7);
            EntityOcelot entitypigzombie8 = new EntityOcelot(this.field_70170_p);
            entitypigzombie8.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie8.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie8.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie8);
            EntityOcelot entitypigzombie9 = new EntityOcelot(this.field_70170_p);
            entitypigzombie9.func_70012_b(this.field_70165_t + 1.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie9.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie9.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie9);
            EntityOcelot entitypigzombie10 = new EntityOcelot(this.field_70170_p);
            entitypigzombie10.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie10.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie10.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie10);
            EntityOcelot entitypigzombie11 = new EntityOcelot(this.field_70170_p);
            entitypigzombie11.func_70012_b(this.field_70165_t - 1.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie11.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie11.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie11);
            EntityOcelot entitypigzombie12 = new EntityOcelot(this.field_70170_p);
            entitypigzombie12.func_70012_b(this.field_70165_t - 2.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie12.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie12.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie12);
            EntityOcelot entitypigzombie13 = new EntityOcelot(this.field_70170_p);
            entitypigzombie13.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v + 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie13.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie13.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie13);
            EntityOcelot entitypigzombie14 = new EntityOcelot(this.field_70170_p);
            entitypigzombie14.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie14.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie14.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie14);
            EntityOcelot entitypigzombie15 = new EntityOcelot(this.field_70170_p);
            entitypigzombie15.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie15.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie15.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie15);
            EntityOcelot entitypigzombie16 = new EntityOcelot(this.field_70170_p);
            entitypigzombie16.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie16.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie16.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie16);
            EntityOcelot entitypigzombie17 = new EntityOcelot(this.field_70170_p);
            entitypigzombie17.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie17.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie17.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie17);
            EntityOcelot entitypigzombie18 = new EntityOcelot(this.field_70170_p);
            entitypigzombie18.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie18.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie18.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie18);
            EntityOcelot entitypigzombie19 = new EntityOcelot(this.field_70170_p);
            entitypigzombie19.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie19.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie19.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie19);
            EntityOcelot entitypigzombie20 = new EntityOcelot(this.field_70170_p);
            entitypigzombie20.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie20.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie20.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie20);
            EntityOcelot entitypigzombie21 = new EntityOcelot(this.field_70170_p);
            entitypigzombie21.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie21.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie21.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie21);
            EntityOcelot entitypigzombie22 = new EntityOcelot(this.field_70170_p);
            entitypigzombie22.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie22.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie22.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie22);
            EntityOcelot entitypigzombie23 = new EntityOcelot(this.field_70170_p);
            entitypigzombie23.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie23.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie23.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie23);
            EntityOcelot entitypigzombie24 = new EntityOcelot(this.field_70170_p);
            entitypigzombie24.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie24.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie24.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie24);
            EntityOcelot entitypigzombie25 = new EntityOcelot(this.field_70170_p);
            entitypigzombie25.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie25.func_96094_a("\u00ef\u00bf\u00bdfCloud");
            entitypigzombie25.func_70912_b(3);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie25);
        }
    }

    public void SuperExplosion() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            this.field_70729_aU = true;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 500.0f, flag);
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    public void HyperExplosion() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            this.field_70729_aU = true;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1000.0f, flag);
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    public void PinkExplosion() {
        if (!this.field_70170_p.field_72995_K) {
            EntitySheep entitypigzombie = new EntitySheep(this.field_70170_p);
            entitypigzombie.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie.func_96094_a("Mr Pink");
            entitypigzombie.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie);
            EntitySheep entitypigzombie2 = new EntitySheep(this.field_70170_p);
            entitypigzombie2.func_70012_b(this.field_70165_t + 1.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie2.func_96094_a("Mr Pink");
            entitypigzombie2.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie2);
            EntitySheep entitypigzombie3 = new EntitySheep(this.field_70170_p);
            entitypigzombie3.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie3.func_96094_a("Mr Pink");
            entitypigzombie3.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie3);
            EntitySheep entitypigzombie4 = new EntitySheep(this.field_70170_p);
            entitypigzombie4.func_70012_b(this.field_70165_t - 1.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie4.func_96094_a("Mr Pink");
            entitypigzombie4.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie);
            EntitySheep entitypigzombie5 = new EntitySheep(this.field_70170_p);
            entitypigzombie5.func_70012_b(this.field_70165_t - 2.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie5.func_96094_a("Mr Pink");
            entitypigzombie5.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie5);
            EntitySheep entitypigzombie6 = new EntitySheep(this.field_70170_p);
            entitypigzombie6.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v + 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie6.func_96094_a("Mr Pink");
            entitypigzombie6.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie6);
            EntitySheep entitypigzombie7 = new EntitySheep(this.field_70170_p);
            entitypigzombie7.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie7.func_96094_a("Mr Pink");
            entitypigzombie7.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie7);
            EntitySheep entitypigzombie8 = new EntitySheep(this.field_70170_p);
            entitypigzombie8.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie8.func_96094_a("Mr Pink");
            entitypigzombie8.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie8);
            EntitySheep entitypigzombie9 = new EntitySheep(this.field_70170_p);
            entitypigzombie9.func_70012_b(this.field_70165_t + 1.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie9.func_96094_a("Mr Pink");
            entitypigzombie9.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie9);
            EntitySheep entitypigzombie10 = new EntitySheep(this.field_70170_p);
            entitypigzombie10.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie10.func_96094_a("Mr Pink");
            entitypigzombie10.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie10);
            EntitySheep entitypigzombie11 = new EntitySheep(this.field_70170_p);
            entitypigzombie11.func_70012_b(this.field_70165_t - 1.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie11.func_96094_a("Mr Pink");
            entitypigzombie11.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie11);
            EntitySheep entitypigzombie12 = new EntitySheep(this.field_70170_p);
            entitypigzombie12.func_70012_b(this.field_70165_t - 2.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie12.func_96094_a("Mr Pink");
            entitypigzombie12.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie12);
            EntitySheep entitypigzombie13 = new EntitySheep(this.field_70170_p);
            entitypigzombie13.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v + 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie13.func_96094_a("Mr Pink");
            entitypigzombie13.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie13);
            EntitySheep entitypigzombie14 = new EntitySheep(this.field_70170_p);
            entitypigzombie14.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie14.func_96094_a("Mr Pink");
            entitypigzombie14.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie14);
            EntitySheep entitypigzombie15 = new EntitySheep(this.field_70170_p);
            entitypigzombie15.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie15.func_96094_a("Mr Pink");
            entitypigzombie15.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie15);
            EntitySheep entitypigzombie16 = new EntitySheep(this.field_70170_p);
            entitypigzombie16.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie16.func_96094_a("Mr Pink");
            entitypigzombie16.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie16);
            EntitySheep entitypigzombie17 = new EntitySheep(this.field_70170_p);
            entitypigzombie17.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie17.func_96094_a("Mr Pink");
            entitypigzombie17.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie17);
            EntitySheep entitypigzombie18 = new EntitySheep(this.field_70170_p);
            entitypigzombie18.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie18.func_96094_a("Mr Pink");
            entitypigzombie18.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie18);
            EntitySheep entitypigzombie19 = new EntitySheep(this.field_70170_p);
            entitypigzombie19.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie19.func_96094_a("Mr Pink");
            entitypigzombie19.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie19);
            EntitySheep entitypigzombie20 = new EntitySheep(this.field_70170_p);
            entitypigzombie20.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie20.func_96094_a("Mr Pink");
            entitypigzombie20.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie20);
            EntitySheep entitypigzombie21 = new EntitySheep(this.field_70170_p);
            entitypigzombie21.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie21.func_96094_a("Mr Pink");
            entitypigzombie21.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie21);
            EntitySheep entitypigzombie22 = new EntitySheep(this.field_70170_p);
            entitypigzombie22.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie22.func_96094_a("Mr Pink");
            entitypigzombie22.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie22);
            EntitySheep entitypigzombie23 = new EntitySheep(this.field_70170_p);
            entitypigzombie23.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie23.func_96094_a("Mr Pink");
            entitypigzombie23.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie23);
            EntitySheep entitypigzombie24 = new EntitySheep(this.field_70170_p);
            entitypigzombie24.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie24.func_96094_a("Mr Pink");
            entitypigzombie24.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie24);
            EntitySheep entitypigzombie25 = new EntitySheep(this.field_70170_p);
            entitypigzombie25.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie25.func_96094_a("Mr Pink");
            entitypigzombie25.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie25);
            EntitySheep entitypigzombie26 = new EntitySheep(this.field_70170_p);
            entitypigzombie26.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie26.func_96094_a("Mr Pink");
            entitypigzombie26.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie26);
            EntitySheep entitypigzombie27 = new EntitySheep(this.field_70170_p);
            entitypigzombie27.func_70012_b(this.field_70165_t + 1.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie27.func_96094_a("Mr Pink");
            entitypigzombie27.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie27);
            EntitySheep entitypigzombie28 = new EntitySheep(this.field_70170_p);
            entitypigzombie28.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie28.func_96094_a("Mr Pink");
            entitypigzombie28.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie28);
            EntitySheep entitypigzombie29 = new EntitySheep(this.field_70170_p);
            entitypigzombie29.func_70012_b(this.field_70165_t - 1.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie29.func_96094_a("Mr Pink");
            entitypigzombie29.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie29);
            EntitySheep entitypigzombie30 = new EntitySheep(this.field_70170_p);
            entitypigzombie30.func_70012_b(this.field_70165_t - 2.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie30.func_96094_a("Mr Pink");
            entitypigzombie30.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie30);
            EntitySheep entitypigzombie31 = new EntitySheep(this.field_70170_p);
            entitypigzombie31.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v + 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie31.func_96094_a("Mr Pink");
            entitypigzombie31.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie31);
            EntitySheep entitypigzombie32 = new EntitySheep(this.field_70170_p);
            entitypigzombie32.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie32.func_96094_a("Mr Pink");
            entitypigzombie32.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie32);
            EntitySheep entitypigzombie33 = new EntitySheep(this.field_70170_p);
            entitypigzombie33.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie33.func_96094_a("Mr Pink");
            entitypigzombie33.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie33);
            EntitySheep entitypigzombie34 = new EntitySheep(this.field_70170_p);
            entitypigzombie34.func_70012_b(this.field_70165_t + 1.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie34.func_96094_a("Mr Pink");
            entitypigzombie34.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie34);
            EntitySheep entitypigzombie35 = new EntitySheep(this.field_70170_p);
            entitypigzombie35.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie35.func_96094_a("Mr Pink");
            entitypigzombie35.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie35);
            EntitySheep entitypigzombie36 = new EntitySheep(this.field_70170_p);
            entitypigzombie36.func_70012_b(this.field_70165_t - 1.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie36.func_96094_a("Mr Pink");
            entitypigzombie36.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie36);
            EntitySheep entitypigzombie37 = new EntitySheep(this.field_70170_p);
            entitypigzombie37.func_70012_b(this.field_70165_t - 2.0, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie37.func_96094_a("Mr Pink");
            entitypigzombie37.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie37);
            EntitySheep entitypigzombie38 = new EntitySheep(this.field_70170_p);
            entitypigzombie38.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v + 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie38.func_96094_a("Mr Pink");
            entitypigzombie38.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie38);
            EntitySheep entitypigzombie39 = new EntitySheep(this.field_70170_p);
            entitypigzombie39.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie39.func_96094_a("Mr Pink");
            entitypigzombie39.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie39);
            EntitySheep entitypigzombie40 = new EntitySheep(this.field_70170_p);
            entitypigzombie40.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie40.func_96094_a("Mr Pink");
            entitypigzombie40.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie40);
            EntitySheep entitypigzombie41 = new EntitySheep(this.field_70170_p);
            entitypigzombie41.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie41.func_96094_a("Mr Pink");
            entitypigzombie41.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie41);
            EntitySheep entitypigzombie42 = new EntitySheep(this.field_70170_p);
            entitypigzombie42.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie42.func_96094_a("Mr Pink");
            entitypigzombie42.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie42);
            EntitySheep entitypigzombie43 = new EntitySheep(this.field_70170_p);
            entitypigzombie43.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie43.func_96094_a("Mr Pink");
            entitypigzombie43.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie43);
            EntitySheep entitypigzombie44 = new EntitySheep(this.field_70170_p);
            entitypigzombie44.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie44.func_96094_a("Mr Pink");
            entitypigzombie44.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie44);
            EntitySheep entitypigzombie45 = new EntitySheep(this.field_70170_p);
            entitypigzombie45.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie45.func_96094_a("Mr Pink");
            entitypigzombie45.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie45);
            EntityBat bat = new EntityBat(this.field_70170_p);
            bat.func_70012_b(this.field_70165_t + 3.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            bat.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 99999));
            this.field_70170_p.func_72838_d((Entity)bat);
            EntityBat bat2 = new EntityBat(this.field_70170_p);
            bat2.func_70012_b(this.field_70165_t + 3.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            bat2.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 99999));
            this.field_70170_p.func_72838_d((Entity)bat2);
            EntityBat bat3 = new EntityBat(this.field_70170_p);
            bat3.func_70012_b(this.field_70165_t + 3.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            bat3.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 99999));
            this.field_70170_p.func_72838_d((Entity)bat3);
            EntityBat bat4 = new EntityBat(this.field_70170_p);
            bat4.func_70012_b(this.field_70165_t + 3.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            bat4.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 99999));
            this.field_70170_p.func_72838_d((Entity)bat4);
            EntityBat bat5 = new EntityBat(this.field_70170_p);
            bat5.func_70012_b(this.field_70165_t + 3.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            bat5.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 99999));
            this.field_70170_p.func_72838_d((Entity)bat5);
            EntitySheep entitypigzombie46 = new EntitySheep(this.field_70170_p);
            entitypigzombie46.func_70012_b(this.field_70165_t + 3.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie46.func_96094_a("Flying Mr Pink");
            entitypigzombie46.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie46);
            entitypigzombie46.func_184220_m((Entity)bat);
            EntitySheep entitypigzombie47 = new EntitySheep(this.field_70170_p);
            entitypigzombie47.func_70012_b(this.field_70165_t + 4.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie47.func_96094_a("Flying Mr Pink");
            entitypigzombie47.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie47);
            entitypigzombie47.func_184220_m((Entity)bat2);
            EntitySheep entitypigzombie48 = new EntitySheep(this.field_70170_p);
            entitypigzombie48.func_70012_b(this.field_70165_t + 5.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie48.func_96094_a("Flying Mr Pink");
            entitypigzombie48.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie48);
            entitypigzombie48.func_184220_m((Entity)bat3);
            EntitySheep entitypigzombie49 = new EntitySheep(this.field_70170_p);
            entitypigzombie49.func_70012_b(this.field_70165_t + -3.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie49.func_96094_a("Flying Mr Pink");
            entitypigzombie49.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie49);
            entitypigzombie49.func_184220_m((Entity)bat4);
            EntitySheep entitypigzombie50 = new EntitySheep(this.field_70170_p);
            entitypigzombie50.func_70012_b(this.field_70165_t + -4.0, this.field_70163_u, this.field_70161_v - 1.0, this.field_70177_z, this.field_70125_A);
            entitypigzombie50.func_96094_a("Flying Mr Pink");
            entitypigzombie50.func_175512_b(EnumDyeColor.PINK);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie50);
            entitypigzombie50.func_184220_m((Entity)bat5);
            this.func_70106_y();
        }
    }

    public void trapExplosion(int radius, Block block, int meta) {
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = new BlockPos((int)this.field_70165_t + x, (int)this.field_70163_u + y, (int)this.field_70161_v + z);
                    if (!block.func_176196_c(this.field_70170_p, pos) || block.func_176196_c(this.field_70170_p, new BlockPos((int)this.field_70165_t + x, (int)this.field_70163_u + y - 1, (int)this.field_70161_v + z))) continue;
                    this.field_70170_p.func_175656_a(pos, block.func_176223_P());
                }
            }
        }
    }

    public void trapExplosion(int radius, Block block) {
        this.trapExplosion(radius, block, 0);
    }

    public void Cake() {
        int radius = 5;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = new BlockPos((int)this.field_70165_t + x, (int)this.field_70163_u + y, (int)this.field_70161_v + z);
                    if (!Blocks.field_150346_d.func_176196_c(this.field_70170_p, pos) || Blocks.field_150346_d.func_176196_c(this.field_70170_p, new BlockPos((int)this.field_70165_t + x, (int)this.field_70163_u + y - 1, (int)this.field_70161_v + z)) || !this.field_70146_Z.nextBoolean()) continue;
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150414_aQ.func_176223_P());
                }
            }
        }
    }

    public void Flame() {
        int radius = 5;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = new BlockPos((int)this.field_70165_t + x, (int)this.field_70163_u + y, (int)this.field_70161_v + z);
                    if (!Blocks.field_150346_d.func_176196_c(this.field_70170_p, pos) || Blocks.field_150346_d.func_176196_c(this.field_70170_p, new BlockPos((int)this.field_70165_t + x, (int)this.field_70163_u + y - 1, (int)this.field_70161_v + z)) || !this.field_70146_Z.nextBoolean()) continue;
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    public void Fly() {
        AxisAlignedBB boundingBox = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(40.0, 20.0, 40.0);
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, boundingBox);
        for (EntityLivingBase entity : entities) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 600));
        }
        this.func_70106_y();
    }

    public void Gravity() {
        AxisAlignedBB boundingBox = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(40.0, 20.0, 40.0);
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, boundingBox);
        for (EntityLivingBase entity : entities) {
            entity.field_70181_x += 2.4000000059604645;
        }
        this.func_70106_y();
    }

    public void woolExplosion(int radius, Block block, int meta) {
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = new BlockPos((int)this.field_70165_t + x, (int)this.field_70163_u + y, (int)this.field_70161_v + z);
                    if (!block.func_176196_c(this.field_70170_p, pos) || !(Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 1.0) + Math.pow(z, 2.0)) <= (double)radius) || this.field_70146_Z.nextInt(4) >= 3) continue;
                    this.field_70170_p.func_175656_a(pos, block.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.PINK));
                }
            }
        }
    }

    public void woolExplosion(int radius, Block block) {
        this.woolExplosion(radius, block, 0);
    }

    public void MegaExplosion(int radius, Block block, int meta) {
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = new BlockPos((int)this.field_70165_t + x, (int)this.field_70163_u + y, (int)this.field_70161_v + z);
                    if (!block.func_176196_c(this.field_70170_p, pos) || !(Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 1.0) + Math.pow(z, 2.0)) <= (double)radius) || this.field_70146_Z.nextInt(4) >= 3) continue;
                    this.field_70170_p.func_175656_a(pos, block.func_176223_P());
                }
            }
        }
    }

    public void MegaExplosion(int radius, Block block) {
        this.MegaExplosion(radius, block, 0);
    }

    public void ThunderStrike() {
        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, false));
        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + 1.0, this.field_70163_u, this.field_70161_v, false));
        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v, false));
        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v + 1.0, false));
        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v + 2.0, false));
        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t - 1.0, this.field_70163_u, this.field_70161_v, false));
        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t - 2.0, this.field_70163_u, this.field_70161_v, false));
        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v - 1.0, false));
        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v - 2.0, false));
        this.func_70106_y();
    }

    public void Warp() {
        AxisAlignedBB boundingBox = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(20.0, 20.0, 20.0);
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, boundingBox);
        for (EntityLivingBase entity : entities) {
            double d0 = entity.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 128.0;
            double d1 = entity.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 6);
            double d2 = entity.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 128.0;
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            entity.func_184595_k(d0, d1, d2);
        }
        this.func_70106_y();
    }

    public void ReverseWarp() {
        AxisAlignedBB boundingBox = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(40.0, 20.0, 40.0);
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, boundingBox);
        for (EntityLivingBase entity : entities) {
            double d0 = this.field_70165_t;
            double d1 = this.field_70163_u;
            double d2 = this.field_70161_v;
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            entity.func_184595_k(d0, d1, d2);
        }
        this.func_70106_y();
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 15.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 5);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 15.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - p_70816_1_.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.field_70161_v - p_70816_1_.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.teleportTo(d1, d2, d3);
    }

    private boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    public void generate() {
        int RandomSize;
        int RandomResources = this.field_70146_Z.nextInt(21);
        if (RandomResources == 0) {
            RandomSize = this.field_70146_Z.nextInt(3);
            this.trapExplosion(RandomSize, Blocks.field_150484_ah);
            this.trapExplosion(RandomSize, Blocks.field_150475_bE);
            this.trapExplosion(RandomSize, (Block)Blocks.field_150461_bJ);
        }
        if (RandomResources == 1) {
            RandomSize = this.field_70146_Z.nextInt(3);
            this.trapExplosion(RandomSize, Blocks.field_150484_ah);
            this.trapExplosion(RandomSize, Blocks.field_150475_bE);
            this.trapExplosion(RandomSize, Blocks.field_150340_R);
            this.trapExplosion(RandomSize, Blocks.field_150339_S);
        }
        if (RandomResources == 2) {
            RandomSize = this.field_70146_Z.nextInt(3);
            this.trapExplosion(RandomSize, Blocks.field_150475_bE);
        }
        if (RandomResources == 3) {
            RandomSize = this.field_70146_Z.nextInt(3);
            this.trapExplosion(RandomSize, Blocks.field_150339_S);
        }
        if (RandomResources == 4) {
            RandomSize = this.field_70146_Z.nextInt(3);
            this.trapExplosion(RandomSize, Blocks.field_150484_ah);
        }
        if (RandomResources == 5) {
            RandomSize = this.field_70146_Z.nextInt(3);
            this.trapExplosion(RandomSize, Blocks.field_150340_R);
        }
        if (RandomResources == 6) {
            RandomSize = this.field_70146_Z.nextInt(2);
            this.trapExplosion(RandomSize, (Block)Blocks.field_150461_bJ);
        }
        if (RandomResources == 7) {
            int RandomAmount = this.field_70146_Z.nextInt(128);
            int RandomApple = this.field_70146_Z.nextInt(64);
            this.func_70099_a(new ItemStack(Items.field_151043_k, RandomAmount / 2), 5.0f);
            this.func_70099_a(new ItemStack(Items.field_151045_i, RandomAmount / 2), 5.0f);
            this.func_70099_a(new ItemStack(Items.field_151166_bC, RandomAmount / 2), 5.0f);
            this.func_70099_a(new ItemStack(Items.field_151042_j, RandomAmount / 2), 5.0f);
            this.func_70099_a(new ItemStack(Items.field_151062_by, RandomAmount / 2), 5.0f);
            this.func_70099_a(new ItemStack(Items.field_151153_ao, RandomApple), 5.0f);
        }
        if (RandomResources == 8) {
            this.trapExplosion(3, Blocks.field_150346_d);
            this.trapExplosion(3, (Block)Blocks.field_150354_m);
            this.trapExplosion(3, Blocks.field_150351_n);
            this.trapExplosion(3, Blocks.field_150347_e);
        }
        if (RandomResources == 9) {
            this.trapExplosion(3, Blocks.field_150335_W);
        }
        if (RandomResources == 10) {
            RandomSize = this.field_70146_Z.nextInt(3);
            this.trapExplosion(RandomSize, Blocks.field_150451_bX);
            this.trapExplosion(RandomSize, Blocks.field_150368_y);
        }
        if (RandomResources == 11 && !this.field_70170_p.field_72995_K) {
            EntityGiantZombie entitypigzombie = new EntityGiantZombie(this.field_70170_p);
            entitypigzombie.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie.func_96094_a("Jen's Mom");
            this.field_70170_p.func_72838_d((Entity)entitypigzombie);
        }
        if (RandomResources == 12) {
            int RandomAm = this.field_70146_Z.nextInt(5);
            this.func_70099_a(new ItemStack(Items.field_151141_av, RandomAm), 5.0f);
            this.func_70099_a(new ItemStack(Items.field_151125_bZ, RandomAm), 5.0f);
            this.func_70099_a(new ItemStack(Items.field_151136_bY, RandomAm), 5.0f);
            this.func_70099_a(new ItemStack(Items.field_151138_bX, RandomAm), 5.0f);
            this.func_70099_a(new ItemStack(Blocks.field_150414_aQ, RandomAm), 5.0f);
            this.func_70099_a(new ItemStack(Blocks.field_150380_bt, RandomAm), 5.0f);
            this.func_70099_a(new ItemStack(Items.field_151156_bN, RandomAm), 5.0f);
        }
        if (RandomResources == 13) {
            this.trapExplosion(3, Blocks.field_150360_v);
        }
        if (RandomResources == 14) {
            int RandomSize2 = this.field_70146_Z.nextInt(3);
            this.trapExplosion(RandomSize2, Blocks.field_150449_bY);
        }
        if (RandomResources == 15) {
            this.trapExplosion(3, Blocks.field_150359_w);
        }
        if (RandomResources == 16) {
            int RandomSize3 = this.field_70146_Z.nextInt(3);
            this.trapExplosion(RandomSize3, Blocks.field_150451_bX);
        }
        if (RandomResources == 17) {
            int RandomSize4 = this.field_70146_Z.nextInt(3);
            this.trapExplosion(RandomSize4, Blocks.field_150368_y);
        }
        if (RandomResources == 18) {
            this.trapExplosion(3, Blocks.field_150342_X);
        }
        if (RandomResources == 19) {
            int RandomSize5 = this.field_70146_Z.nextInt(3);
            int RandomAmount = this.field_70146_Z.nextInt(128);
            this.func_70099_a(new ItemStack(Items.field_151115_aP, RandomAmount / 2), 5.0f);
            this.trapExplosion(RandomSize5, (Block)Blocks.field_150358_i);
            if (!this.field_70170_p.field_72995_K) {
                EntitySquid entitypigzombie = new EntitySquid(this.field_70170_p);
                entitypigzombie.func_70012_b(this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                entitypigzombie.func_96094_a("I'm a fish!");
                this.field_70170_p.func_72838_d((Entity)entitypigzombie);
                EntitySquid entitypigzombie2 = new EntitySquid(this.field_70170_p);
                entitypigzombie2.func_70012_b(this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                entitypigzombie2.func_96094_a("I'm a fish!");
                this.field_70170_p.func_72838_d((Entity)entitypigzombie2);
                EntitySquid entitypigzombie3 = new EntitySquid(this.field_70170_p);
                entitypigzombie3.func_70012_b(this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                entitypigzombie3.func_96094_a("I'm a fish!");
                this.field_70170_p.func_72838_d((Entity)entitypigzombie3);
            }
        }
        if (RandomResources == 20) {
            this.woolExplosion(5, Blocks.field_150325_L, 5);
            if (!this.field_70170_p.field_72995_K) {
                EntitySheep entitypigzombie = new EntitySheep(this.field_70170_p);
                entitypigzombie.func_70012_b(this.field_70165_t + 5.0, this.field_70163_u + 4.0, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                entitypigzombie.func_96094_a("Mr Pink");
                entitypigzombie.func_175512_b(EnumDyeColor.PINK);
                this.field_70170_p.func_72838_d((Entity)entitypigzombie);
                EntitySheep entitypigzombie2 = new EntitySheep(this.field_70170_p);
                entitypigzombie2.func_70012_b(this.field_70165_t + 5.0, this.field_70163_u + 4.0, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                entitypigzombie2.func_96094_a("Mr Pink");
                entitypigzombie2.func_175512_b(EnumDyeColor.PINK);
                this.field_70170_p.func_72838_d((Entity)entitypigzombie2);
                EntitySheep entitypigzombie3 = new EntitySheep(this.field_70170_p);
                entitypigzombie3.func_70012_b(this.field_70165_t + 5.0, this.field_70163_u + 4.0, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                entitypigzombie3.func_96094_a("Mr Pink");
                entitypigzombie3.func_175512_b(EnumDyeColor.PINK);
                this.field_70170_p.func_72838_d((Entity)entitypigzombie3);
                EntitySheep entitypigzombie4 = new EntitySheep(this.field_70170_p);
                entitypigzombie4.func_70012_b(this.field_70165_t + 5.0, this.field_70163_u + 4.0, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                entitypigzombie4.func_96094_a("Mr Pink");
                entitypigzombie4.func_175512_b(EnumDyeColor.PINK);
                this.field_70170_p.func_72838_d((Entity)entitypigzombie4);
                EntitySheep entitypigzombie5 = new EntitySheep(this.field_70170_p);
                entitypigzombie5.func_70012_b(this.field_70165_t + 5.0, this.field_70163_u + 4.0, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                entitypigzombie5.func_96094_a("Mr Pink");
                entitypigzombie5.func_175512_b(EnumDyeColor.PINK);
                this.field_70170_p.func_72838_d((Entity)entitypigzombie5);
            }
        }
    }

    public void sandExplosion(int radius, Block block, int meta) {
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = new BlockPos((int)this.field_70165_t + x, (int)this.field_70163_u + y, (int)this.field_70161_v + z);
                    if (!block.func_176196_c(this.field_70170_p, pos) || !(Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 1.0) + Math.pow(z, 2.0)) <= (double)radius) || this.field_70146_Z.nextInt(4) >= 3) continue;
                    this.field_70170_p.func_175656_a(pos, block.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND));
                }
            }
        }
    }

    public void sandExplosion(int radius, Block block) {
        this.sandExplosion(radius, block, 0);
    }

    private void explode() {
        if (this.getCreeperType() == 0) {
            this.SmallExplosion();
        } else if (this.getCreeperType() == 1) {
            this.LargeExplosion();
        } else if (this.getCreeperType() == 2) {
            this.PinkExplosion();
        } else if (this.getCreeperType() == 3) {
            this.trapExplosion(3, (Block)Blocks.field_150358_i);
            this.func_70106_y();
        } else if (this.getCreeperType() == 4) {
            this.trapExplosion(3, (Block)Blocks.field_150356_k);
            this.func_70106_y();
        } else if (this.getCreeperType() == 5) {
            this.Flame();
            this.func_70106_y();
        } else if (this.getCreeperType() == 6) {
            this.Fly();
        } else if (this.getCreeperType() == 7) {
            this.Gravity();
        } else if (this.getCreeperType() == 8) {
            this.MegaExplosion(5, Blocks.field_150343_Z);
            this.func_70106_y();
        } else if (this.getCreeperType() == 9) {
            this.ThunderStrike();
        } else if (this.getCreeperType() == 10) {
            this.Warp();
        } else if (this.getCreeperType() == 11) {
            this.ReverseWarp();
        } else if (this.getCreeperType() == 12) {
            this.generate();
            this.func_70106_y();
        } else if (this.getCreeperType() == 13) {
            this.Scatter();
            this.func_70106_y();
        } else if (this.getCreeperType() == 14) {
            this.TurnGold();
            this.func_70106_y();
        } else if (this.getCreeperType() == 15) {
            this.LargeExplosion();
        } else if (this.getCreeperType() == 16) {
            this.HugeExplosion();
        } else if (this.getCreeperType() == 17) {
            this.SpawnCloud();
            this.func_70106_y();
        } else if (this.getCreeperType() == 18) {
            this.SetTime();
            this.func_70106_y();
        } else if (this.getCreeperType() == 19) {
            this.Cake();
            this.func_70106_y();
        } else if (this.getCreeperType() == 20) {
            this.MegaExplosion(3, Blocks.field_150346_d);
            this.func_70106_y();
        } else if (this.getCreeperType() == 21) {
            this.MegaExplosion(3, Blocks.field_150348_b);
            this.func_70106_y();
        } else if (this.getCreeperType() == 22) {
            this.MegaExplosion(3, Blocks.field_150435_aG);
            this.func_70106_y();
        } else if (this.getCreeperType() == 23) {
            this.MegaExplosion(3, Blocks.field_150432_aD);
            this.func_70106_y();
        } else if (this.getCreeperType() == 24) {
            this.MegaExplosion(3, Blocks.field_150433_aE);
            this.func_70106_y();
        } else if (this.getCreeperType() == 25) {
            this.MegaExplosion(3, (Block)Blocks.field_150354_m);
            this.func_70106_y();
        } else if (this.getCreeperType() == 26) {
            this.sandExplosion(3, (Block)Blocks.field_150354_m, 1);
            this.func_70106_y();
        } else if (this.getCreeperType() == 27) {
            this.MegaExplosion(3, (Block)Blocks.field_150362_t);
            this.func_70106_y();
        } else if (this.getCreeperType() == 28) {
            this.MegaExplosion(2, Blocks.field_150346_d);
            this.func_70106_y();
        } else if (this.getCreeperType() == 29) {
            this.MegaExplosion(2, Blocks.field_150347_e);
            this.func_70106_y();
        } else if (this.getCreeperType() == 30) {
            this.func_70099_a(new ItemStack(Items.field_151045_i, 1), 1.0f);
            this.func_70099_a(new ItemStack(Items.field_151143_au, 1), 1.0f);
            this.func_70106_y();
        } else if (this.getCreeperType() == 31) {
            this.woolExplosion(2, Blocks.field_150325_L, 5);
            this.func_70106_y();
        } else if (this.getCreeperType() == 32) {
            this.woolExplosion(2, Blocks.field_150325_L, 11);
            this.func_70106_y();
        } else if (this.getCreeperType() == 33) {
            this.woolExplosion(4, Blocks.field_150325_L, 11);
            this.func_70106_y();
        } else {
            this.SmallExplosion();
        }
    }

    public void TurnGold() {
        AxisAlignedBB boundingBox = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(10.0, 10.0, 10.0);
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, boundingBox);
        for (EntityLivingBase entity : entities) {
            if (entity instanceof EntityLiving && entity.func_110138_aP() <= 50.0f) {
                entity.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
                entity.func_184174_b(false);
                entity.func_70099_a(new ItemStack(Items.field_151043_k, 1), 1.0f);
                continue;
            }
            if (!(entity instanceof EntityPlayer) || ((EntityPlayer)entity).field_71075_bZ.field_75098_d) continue;
            entity.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
            entity.func_184174_b(false);
            entity.func_70099_a(new ItemStack(Items.field_151043_k, 1), 1.0f);
        }
    }

    public void Scatter() {
        if (!this.field_70170_p.field_72995_K) {
            EntityDynamiteCreeper entitypigzombie = new EntityDynamiteCreeper(this.field_70170_p);
            entitypigzombie.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie.setCreeperType(0);
            entitypigzombie.field_70179_y += (double)this.field_70146_Z.nextInt(2);
            entitypigzombie.field_70181_x += (double)this.field_70146_Z.nextInt(1);
            entitypigzombie.field_70159_w += (double)this.field_70146_Z.nextInt(2);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie);
            EntityDynamiteCreeper entitypigzombie2 = new EntityDynamiteCreeper(this.field_70170_p);
            entitypigzombie2.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie2.setCreeperType(0);
            entitypigzombie2.field_70179_y += (double)this.field_70146_Z.nextInt(2);
            entitypigzombie2.field_70181_x += (double)this.field_70146_Z.nextInt(1);
            entitypigzombie2.field_70159_w += (double)this.field_70146_Z.nextInt(2);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie2);
            EntityDynamiteCreeper entitypigzombie3 = new EntityDynamiteCreeper(this.field_70170_p);
            entitypigzombie3.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie3.setCreeperType(0);
            entitypigzombie3.field_70179_y += (double)this.field_70146_Z.nextInt(2);
            entitypigzombie3.field_70181_x += (double)this.field_70146_Z.nextInt(1);
            entitypigzombie3.field_70159_w += (double)this.field_70146_Z.nextInt(2);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie3);
            EntityDynamiteCreeper entitypigzombie4 = new EntityDynamiteCreeper(this.field_70170_p);
            entitypigzombie4.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie4.setCreeperType(0);
            entitypigzombie4.field_70179_y += (double)this.field_70146_Z.nextInt(2);
            entitypigzombie4.field_70181_x += (double)this.field_70146_Z.nextInt(1);
            entitypigzombie4.field_70159_w += (double)this.field_70146_Z.nextInt(2);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie4);
            EntityDynamiteCreeper entitypigzombie5 = new EntityDynamiteCreeper(this.field_70170_p);
            entitypigzombie5.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie5.setCreeperType(0);
            entitypigzombie5.field_70179_y += (double)this.field_70146_Z.nextInt(2);
            entitypigzombie5.field_70181_x += (double)this.field_70146_Z.nextInt(1);
            entitypigzombie5.field_70159_w += (double)this.field_70146_Z.nextInt(2);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie5);
            EntityDynamiteCreeper entitypigzombie6 = new EntityDynamiteCreeper(this.field_70170_p);
            entitypigzombie6.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie6.setCreeperType(0);
            entitypigzombie6.field_70179_y += (double)this.field_70146_Z.nextInt(2);
            entitypigzombie6.field_70181_x += (double)this.field_70146_Z.nextInt(1);
            entitypigzombie6.field_70159_w += (double)this.field_70146_Z.nextInt(2);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie6);
            EntityDynamiteCreeper entitypigzombie7 = new EntityDynamiteCreeper(this.field_70170_p);
            entitypigzombie7.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie7.setCreeperType(0);
            entitypigzombie7.field_70179_y += (double)this.field_70146_Z.nextInt(2);
            entitypigzombie7.field_70181_x += (double)this.field_70146_Z.nextInt(1);
            entitypigzombie7.field_70159_w += (double)this.field_70146_Z.nextInt(2);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie7);
            EntityDynamiteCreeper entitypigzombie8 = new EntityDynamiteCreeper(this.field_70170_p);
            entitypigzombie8.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie8.setCreeperType(0);
            entitypigzombie8.field_70179_y += (double)this.field_70146_Z.nextInt(2);
            entitypigzombie8.field_70181_x += (double)this.field_70146_Z.nextInt(1);
            entitypigzombie8.field_70159_w += (double)this.field_70146_Z.nextInt(2);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie8);
            EntityDynamiteCreeper entitypigzombie9 = new EntityDynamiteCreeper(this.field_70170_p);
            entitypigzombie9.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie9.setCreeperType(0);
            entitypigzombie9.field_70179_y += (double)this.field_70146_Z.nextInt(2);
            entitypigzombie9.field_70181_x += (double)this.field_70146_Z.nextInt(1);
            entitypigzombie9.field_70159_w += (double)this.field_70146_Z.nextInt(2);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie9);
            EntityDynamiteCreeper entitypigzombie10 = new EntityDynamiteCreeper(this.field_70170_p);
            entitypigzombie10.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie10.setCreeperType(0);
            entitypigzombie10.field_70179_y += (double)this.field_70146_Z.nextInt(2);
            entitypigzombie10.field_70181_x += (double)this.field_70146_Z.nextInt(1);
            entitypigzombie10.field_70159_w += (double)this.field_70146_Z.nextInt(2);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie10);
            EntityDynamiteCreeper entitypigzombie11 = new EntityDynamiteCreeper(this.field_70170_p);
            entitypigzombie11.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie11.setCreeperType(0);
            entitypigzombie11.field_70179_y += (double)this.field_70146_Z.nextInt(2);
            entitypigzombie11.field_70181_x += (double)this.field_70146_Z.nextInt(1);
            entitypigzombie11.field_70159_w += (double)this.field_70146_Z.nextInt(2);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie11);
            EntityDynamiteCreeper entitypigzombie12 = new EntityDynamiteCreeper(this.field_70170_p);
            entitypigzombie12.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie12.setCreeperType(0);
            entitypigzombie12.field_70179_y += (double)this.field_70146_Z.nextInt(2);
            entitypigzombie12.field_70181_x += (double)this.field_70146_Z.nextInt(1);
            entitypigzombie12.field_70159_w += (double)this.field_70146_Z.nextInt(2);
            this.field_70170_p.func_72838_d((Entity)entitypigzombie12);
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.func_70651_bq();
        if (!collection.isEmpty()) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityareaeffectcloud.func_184483_a(2.5f);
            entityareaeffectcloud.func_184495_b(-0.5f);
            entityareaeffectcloud.func_184485_d(10);
            entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 2);
            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
            for (PotionEffect potioneffect : collection) {
                entityareaeffectcloud.func_184496_a(new PotionEffect(potioneffect));
            }
            this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
        }
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    public boolean isAIEnabled() {
        return this.droppedSkulls < 1 && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot");
    }

    public void incrementDroppedSkulls() {
        ++this.droppedSkulls;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        int i;
        if ((livingdata = super.func_180482_a(difficulty, livingdata)) instanceof GroupData) {
            i = ((GroupData)livingdata).variant;
        } else {
            i = this.field_70146_Z.nextInt(40);
            livingdata = new GroupData(i);
        }
        this.setCreeperType(i);
        this.SetAttributes();
        return livingdata;
    }

    public static class GroupData
    implements IEntityLivingData {
        public int variant;

        public GroupData(int variantIn) {
            this.variant = variantIn;
        }
    }
}

